# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import json
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from synctera_client.models.template_fields_charge_secured import TemplateFieldsChargeSecured
from synctera_client.models.template_fields_depository import TemplateFieldsDepository
from synctera_client.models.template_fields_line_of_credit import TemplateFieldsLineOfCredit
from typing import Any, List
from pydantic import StrictStr, Field

TEMPLATEFIELDS_ONE_OF_SCHEMAS = ["TemplateFieldsChargeSecured", "TemplateFieldsDepository", "TemplateFieldsLineOfCredit"]

class TemplateFields(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: TemplateFieldsDepository
    __oneof_schema_1: Optional[TemplateFieldsDepository] = None
    # data type: TemplateFieldsLineOfCredit
    __oneof_schema_2: Optional[TemplateFieldsLineOfCredit] = None
    # data type: TemplateFieldsChargeSecured
    __oneof_schema_3: Optional[TemplateFieldsChargeSecured] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(TEMPLATEFIELDS_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        error_messages = []
        match = 0
        # validate data type: TemplateFieldsDepository
        if type(v) is not TemplateFieldsDepository:
            error_messages.append(f"Error! Input type `{type(v)}` is not `TemplateFieldsDepository`")
        else:
            match += 1

        # validate data type: TemplateFieldsLineOfCredit
        if type(v) is not TemplateFieldsLineOfCredit:
            error_messages.append(f"Error! Input type `{type(v)}` is not `TemplateFieldsLineOfCredit`")
        else:
            match += 1

        # validate data type: TemplateFieldsChargeSecured
        if type(v) is not TemplateFieldsChargeSecured:
            error_messages.append(f"Error! Input type `{type(v)}` is not `TemplateFieldsChargeSecured`")
        else:
            match += 1

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TemplateFields with oneOf schemas: TemplateFieldsChargeSecured, TemplateFieldsDepository, TemplateFieldsLineOfCredit. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TemplateFields with oneOf schemas: TemplateFieldsChargeSecured, TemplateFieldsDepository, TemplateFieldsLineOfCredit. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> TemplateFields:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> TemplateFields:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into TemplateFieldsDepository
        try:
            instance.actual_instance = TemplateFieldsDepository.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into TemplateFieldsLineOfCredit
        try:
            instance.actual_instance = TemplateFieldsLineOfCredit.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into TemplateFieldsChargeSecured
        try:
            instance.actual_instance = TemplateFieldsChargeSecured.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into TemplateFields with oneOf schemas: TemplateFieldsChargeSecured, TemplateFieldsDepository, TemplateFieldsLineOfCredit. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into TemplateFields with oneOf schemas: TemplateFieldsChargeSecured, TemplateFieldsDepository, TemplateFieldsLineOfCredit. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())





