# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, conint, validator

class ScheduleConfig(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    count: Optional[conint(strict=True, ge=1)] = Field(None, description="Number of times to recur. Exactly one of end_date or count must be provided")
    end_date: Optional[date] = Field(None, description="End date of the schedule (exclusive). Exactly one of end_date or count must be provided")
    frequency: StrictStr = ...
    interval: conint(strict=True, le=366, ge=1) = Field(..., description="Interval between recurrences, e.g. interval = 2 with frequency = WEEKLY means every other week.")
    start_date: date = Field(..., description="Start date of the schedule (inclusive)")
    __properties = ["count", "end_date", "frequency", "interval", "start_date"]

    @validator('frequency')
    def frequency_validate_enum(cls, v):
        if v not in ('DAILY', 'WEEKLY', 'MONTHLY'):
            raise ValueError("must validate the enum values ('DAILY', 'WEEKLY', 'MONTHLY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ScheduleConfig:
        """Create an instance of ScheduleConfig from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ScheduleConfig:
        """Create an instance of ScheduleConfig from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ScheduleConfig.parse_obj(obj)

        _obj = ScheduleConfig.parse_obj({
            "count": obj.get("count"),
            "end_date": obj.get("end_date"),
            "frequency": obj.get("frequency"),
            "interval": obj.get("interval"),
            "start_date": obj.get("start_date")
        })
        return _obj

