# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictFloat, StrictStr, validator

class RiskRating(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    configuration_id: Optional[StrictStr] = Field(None, description="The risk configuration id used in risk score calculation")
    id: Optional[StrictStr] = Field(None, description="Risk rating ID")
    next_review: Optional[datetime] = Field(None, description="The next review date where customer risk will be calculated")
    risk_level: Optional[StrictStr] = Field(None, description="A textual representation of the customer risk score")
    risk_review: Optional[datetime] = Field(None, description="The date the customer risk rating was calculated")
    risk_score: Optional[StrictFloat] = Field(None, description="The cumulative score of all risk rating fields")
    __properties = ["configuration_id", "id", "next_review", "risk_level", "risk_review", "risk_score"]

    @validator('risk_level')
    def risk_level_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('low', 'medium', 'high'):
            raise ValueError("must validate the enum values ('low', 'medium', 'high')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> RiskRating:
        """Create an instance of RiskRating from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "configuration_id",
                            "id",
                            "risk_review",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> RiskRating:
        """Create an instance of RiskRating from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return RiskRating.parse_obj(obj)

        _obj = RiskRating.parse_obj({
            "configuration_id": obj.get("configuration_id"),
            "id": obj.get("id"),
            "next_review": obj.get("next_review"),
            "risk_level": obj.get("risk_level"),
            "risk_review": obj.get("risk_review"),
            "risk_score": obj.get("risk_score")
        })
        return _obj

