# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr

class ResponseHistoryItem(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    code: Optional[StrictInt] = Field(None, description="Response code from the request")
    response_body: Optional[StrictStr] = Field(None, description="Response body from the request(Length more than 1024 will be trimmed)")
    response_time: Optional[datetime] = Field(None, description="Timestamp that the response is received")
    sent_time: Optional[datetime] = Field(None, description="Timestamp that the request is sent")
    __properties = ["code", "response_body", "response_time", "sent_time"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ResponseHistoryItem:
        """Create an instance of ResponseHistoryItem from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ResponseHistoryItem:
        """Create an instance of ResponseHistoryItem from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ResponseHistoryItem.parse_obj(obj)

        _obj = ResponseHistoryItem.parse_obj({
            "code": obj.get("code"),
            "response_body": obj.get("response_body"),
            "response_time": obj.get("response_time"),
            "sent_time": obj.get("sent_time")
        })
        return _obj

