# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, StrictStr
from synctera_client.models.address1 import Address1

class PushTokenizeRequestData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    display_name: Optional[StrictStr] = None
    last_digits: Optional[StrictStr] = None
    network: Optional[StrictStr] = None
    opaque_payment_card: Optional[StrictStr] = None
    token_service_provider: Optional[StrictStr] = None
    user_address: Optional[Address1] = None
    __properties = ["display_name", "last_digits", "network", "opaque_payment_card", "token_service_provider", "user_address"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PushTokenizeRequestData:
        """Create an instance of PushTokenizeRequestData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of user_address
        if self.user_address:
            _dict['user_address'] = self.user_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PushTokenizeRequestData:
        """Create an instance of PushTokenizeRequestData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PushTokenizeRequestData.parse_obj(obj)

        _obj = PushTokenizeRequestData.parse_obj({
            "display_name": obj.get("display_name"),
            "last_digits": obj.get("last_digits"),
            "network": obj.get("network"),
            "opaque_payment_card": obj.get("opaque_payment_card"),
            "token_service_provider": obj.get("token_service_provider"),
            "user_address": Address1.from_dict(obj.get("user_address")) if obj.get("user_address") is not None else None
        })
        return _obj

