# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.card_fulfillment_status import CardFulfillmentStatus
from synctera_client.models.fulfillment_details import FulfillmentDetails

class PhysicalCardResponseStatusAllOf(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    card_fulfillment_status: CardFulfillmentStatus = ...
    fulfillment_details: Optional[FulfillmentDetails] = None
    tracking_number: Optional[StrictStr] = Field(None, description="This contains all shipping details as provided by the card fulfillment provider, including the tracking number. This field is deprecated. Instead, please use the fulfillment_details object, which includes a field for just the tracking number. ")
    __properties = ["card_fulfillment_status", "fulfillment_details", "tracking_number"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PhysicalCardResponseStatusAllOf:
        """Create an instance of PhysicalCardResponseStatusAllOf from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "tracking_number",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of fulfillment_details
        if self.fulfillment_details:
            _dict['fulfillment_details'] = self.fulfillment_details.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PhysicalCardResponseStatusAllOf:
        """Create an instance of PhysicalCardResponseStatusAllOf from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PhysicalCardResponseStatusAllOf.parse_obj(obj)

        _obj = PhysicalCardResponseStatusAllOf.parse_obj({
            "card_fulfillment_status": obj.get("card_fulfillment_status"),
            "fulfillment_details": FulfillmentDetails.from_dict(obj.get("fulfillment_details")) if obj.get("fulfillment_details") is not None else None,
            "tracking_number": obj.get("tracking_number")
        })
        return _obj

