# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, conint, validator
from synctera_client.models.dc_sign import DcSign
from synctera_client.models.pending_transaction_history import PendingTransactionHistory

class PendingTransactionData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: conint(strict=True, ge=0) = Field(..., description="The amount of the hold.")
    auto_post_at: datetime = Field(..., description="The account \"available balance\" at the time this hold was created")
    avail_balance: StrictInt = Field(..., description="The account \"available balance\" at the time this hold was created (to be deprecated)")
    available_balance: StrictInt = Field(..., description="The account \"available balance\" at the time this hold was created")
    balance: StrictInt = Field(..., description="The account balance at the time this hold was created")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    dc_sign: DcSign = ...
    effective_date: datetime = Field(..., description="The effective date of the transaction once it gets posted")
    expires_at: datetime = Field(..., description="The date that at which this hold is no longer valid.")
    external_data: Optional[Dict[str, Any]] = Field(None, description="an unstructured json blob representing additional transaction information supplied by the integrator.")
    force_post: StrictBool = Field(..., description="Whether or not the hold was forced (spending controls ignored)")
    history: List[PendingTransactionHistory] = Field(..., description="An array representing any previous states of the hold, if it has been modified (For example, increasing or decreasing the hold amount).")
    idemkey: StrictStr = Field(..., description="The idempotency key used when initially creating this hold.")
    memo: StrictStr = Field(..., description="A short note to the recipient")
    network: StrictStr = Field(..., description="The network this transaction is associated with")
    operation: StrictStr = ...
    reason: StrictStr = Field(..., description="If a hold has been declined or modified, this will include the reason.")
    req_amount: conint(strict=True, ge=0) = Field(..., description="The requested amount, in the case of hold modifications.")
    risk_info: Optional[Dict[str, Any]] = Field(None, description="Information received by the transaction risk/fraud service related to this transaction")
    status: StrictStr = Field(..., description="The status of the hold.")
    subtype: StrictStr = Field(..., description="The specific transaction type. For example, for `ach`, this may be \"outgoing_debit\".")
    total_amount: conint(strict=True, ge=0) = Field(..., description="The total amount of the hold. This may be different than `amount` in the case where a hold increase or decrease was requested.")
    transaction_id: Optional[StrictStr] = Field(None, description="The uuid of the transaction that this pending transaction originated from, if any. This is primary used when a transaction \"posts\", but a subset of the amount reserved until a future settlement date.")
    transaction_time: datetime = Field(..., description="The time that the transaction was created")
    type: StrictStr = Field(..., description="The general type of transaction. For example, \"card\" or \"ach\".")
    user_data: Optional[Dict[str, Any]] = Field(None, description="An unstructured JSON blob representing additional transaction information specific to each payment rail.")
    was_partial: StrictBool = Field(..., description="Does this hold represent a partial debit (or credit)?")
    __properties = ["amount", "auto_post_at", "avail_balance", "available_balance", "balance", "currency", "dc_sign", "effective_date", "expires_at", "external_data", "force_post", "history", "idemkey", "memo", "network", "operation", "reason", "req_amount", "risk_info", "status", "subtype", "total_amount", "transaction_id", "transaction_time", "type", "user_data", "was_partial"]

    @validator('operation')
    def operation_validate_enum(cls, v):
        if v not in ('hold_new', 'hold_increase', 'hold_decrease', 'hold_replace', 'hold_decline', 'hold_cancel', 'hold_post', 'hold_expire'):
            raise ValueError("must validate the enum values ('hold_new', 'hold_increase', 'hold_decrease', 'hold_replace', 'hold_decline', 'hold_cancel', 'hold_post', 'hold_expire')")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('PENDING', 'REPLACED', 'DECLINED', 'RELEASED', 'PARTCLEARED', 'EXPIRED', 'CLEARED', 'INTERNAL_ERROR'):
            raise ValueError("must validate the enum values ('PENDING', 'REPLACED', 'DECLINED', 'RELEASED', 'PARTCLEARED', 'EXPIRED', 'CLEARED', 'INTERNAL_ERROR')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PendingTransactionData:
        """Create an instance of PendingTransactionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in history (list)
        _items = []
        if self.history:
            for _item in self.history:
                if _item:
                    _items.append(_item.to_dict())
            _dict['history'] = _items
        # set to None if external_data (nullable) is None
        if self.external_data is None:
            _dict['external_data'] = None

        # set to None if risk_info (nullable) is None
        if self.risk_info is None:
            _dict['risk_info'] = None

        # set to None if user_data (nullable) is None
        if self.user_data is None:
            _dict['user_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PendingTransactionData:
        """Create an instance of PendingTransactionData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PendingTransactionData.parse_obj(obj)

        _obj = PendingTransactionData.parse_obj({
            "amount": obj.get("amount"),
            "auto_post_at": obj.get("auto_post_at"),
            "avail_balance": obj.get("avail_balance"),
            "available_balance": obj.get("available_balance"),
            "balance": obj.get("balance"),
            "currency": obj.get("currency"),
            "dc_sign": obj.get("dc_sign"),
            "effective_date": obj.get("effective_date"),
            "expires_at": obj.get("expires_at"),
            "external_data": obj.get("external_data"),
            "force_post": obj.get("force_post"),
            "history": [PendingTransactionHistory.from_dict(_item) for _item in obj.get("history")] if obj.get("history") is not None else None,
            "idemkey": obj.get("idemkey"),
            "memo": obj.get("memo"),
            "network": obj.get("network"),
            "operation": obj.get("operation"),
            "reason": obj.get("reason"),
            "req_amount": obj.get("req_amount"),
            "risk_info": obj.get("risk_info"),
            "status": obj.get("status"),
            "subtype": obj.get("subtype"),
            "total_amount": obj.get("total_amount"),
            "transaction_id": obj.get("transaction_id"),
            "transaction_time": obj.get("transaction_time"),
            "type": obj.get("type"),
            "user_data": obj.get("user_data"),
            "was_partial": obj.get("was_partial")
        })
        return _obj

