# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.payment_date import PaymentDate
from synctera_client.models.payment_error_details import PaymentErrorDetails
from synctera_client.models.payment_instruction import PaymentInstruction
from synctera_client.models.payment_status import PaymentStatus

class Payment(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    description: Optional[StrictStr] = Field(None, description="User provided description for the payment schedule")
    error_details: Optional[PaymentErrorDetails] = None
    id: Optional[StrictStr] = Field(None, description="Payment ID")
    metadata: Optional[Dict[str, Any]] = Field(None, description="User provided JSON format data for the payment schedule")
    payment_date: Optional[PaymentDate] = None
    payment_instruction: Optional[PaymentInstruction] = None
    payment_schedule_id: Optional[StrictStr] = Field(None, description="ID of the payment schedule that executed this payment")
    status: Optional[PaymentStatus] = None
    transaction_id: Optional[StrictStr] = Field(None, description="Transaction ID. It will be included only when status is COMPLETED")
    __properties = ["description", "error_details", "id", "metadata", "payment_date", "payment_instruction", "payment_schedule_id", "status", "transaction_id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Payment:
        """Create an instance of Payment from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of error_details
        if self.error_details:
            _dict['error_details'] = self.error_details.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_date
        if self.payment_date:
            _dict['payment_date'] = self.payment_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of payment_instruction
        if self.payment_instruction:
            _dict['payment_instruction'] = self.payment_instruction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Payment:
        """Create an instance of Payment from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Payment.parse_obj(obj)

        _obj = Payment.parse_obj({
            "description": obj.get("description"),
            "error_details": PaymentErrorDetails.from_dict(obj.get("error_details")) if obj.get("error_details") is not None else None,
            "id": obj.get("id"),
            "metadata": obj.get("metadata"),
            "payment_date": PaymentDate.from_dict(obj.get("payment_date")) if obj.get("payment_date") is not None else None,
            "payment_instruction": PaymentInstruction.from_dict(obj.get("payment_instruction")) if obj.get("payment_instruction") is not None else None,
            "payment_schedule_id": obj.get("payment_schedule_id"),
            "status": obj.get("status"),
            "transaction_id": obj.get("transaction_id")
        })
        return _obj

