# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import json
import re  # noqa: F401

from typing import Any, List, Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from synctera_client.models.patch_business_business_owner_relationship import PatchBusinessBusinessOwnerRelationship
from synctera_client.models.patch_person_business_owner_relationship import PatchPersonBusinessOwnerRelationship
from synctera_client.models.patch_person_business_relationship import PatchPersonBusinessRelationship
from typing import Any, List
from pydantic import StrictStr, Field

PATCHRELATIONSHIPIN_ONE_OF_SCHEMAS = ["PatchBusinessBusinessOwnerRelationship", "PatchPersonBusinessOwnerRelationship", "PatchPersonBusinessRelationship"]

class PatchRelationshipIn(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: PatchPersonBusinessRelationship
    __oneof_schema_1: Optional[PatchPersonBusinessRelationship] = None
    # data type: PatchPersonBusinessOwnerRelationship
    __oneof_schema_2: Optional[PatchPersonBusinessOwnerRelationship] = None
    # data type: PatchBusinessBusinessOwnerRelationship
    __oneof_schema_3: Optional[PatchBusinessBusinessOwnerRelationship] = None
    actual_instance: Any
    one_of_schemas: List[str] = Field(PATCHRELATIONSHIPIN_ONE_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    discriminator_value_class_map = {
    }

    @validator('actual_instance')
    def actual_instance_must_validate_oneof(cls, v):
        error_messages = []
        match = 0
        # validate data type: PatchPersonBusinessRelationship
        if type(v) is not PatchPersonBusinessRelationship:
            error_messages.append(f"Error! Input type `{type(v)}` is not `PatchPersonBusinessRelationship`")
        else:
            match += 1

        # validate data type: PatchPersonBusinessOwnerRelationship
        if type(v) is not PatchPersonBusinessOwnerRelationship:
            error_messages.append(f"Error! Input type `{type(v)}` is not `PatchPersonBusinessOwnerRelationship`")
        else:
            match += 1

        # validate data type: PatchBusinessBusinessOwnerRelationship
        if type(v) is not PatchBusinessBusinessOwnerRelationship:
            error_messages.append(f"Error! Input type `{type(v)}` is not `PatchBusinessBusinessOwnerRelationship`")
        else:
            match += 1

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PatchRelationshipIn with oneOf schemas: PatchBusinessBusinessOwnerRelationship, PatchPersonBusinessOwnerRelationship, PatchPersonBusinessRelationship. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PatchRelationshipIn with oneOf schemas: PatchBusinessBusinessOwnerRelationship, PatchPersonBusinessOwnerRelationship, PatchPersonBusinessRelationship. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_dict(cls, obj: dict) -> PatchRelationshipIn:
        return cls.from_json(json.dumps(obj))

    @classmethod
    def from_json(cls, json_str: str) -> PatchRelationshipIn:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        match = 0

        # deserialize data into PatchPersonBusinessRelationship
        try:
            instance.actual_instance = PatchPersonBusinessRelationship.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into PatchPersonBusinessOwnerRelationship
        try:
            instance.actual_instance = PatchPersonBusinessOwnerRelationship.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))
        # deserialize data into PatchBusinessBusinessOwnerRelationship
        try:
            instance.actual_instance = PatchBusinessBusinessOwnerRelationship.from_json(json_str)
            match += 1
        except ValidationError as e:
            error_messages.append(str(e))

        if match > 1:
            # more than 1 match
            raise ValueError("Multiple matches found when deserializing the JSON string into PatchRelationshipIn with oneOf schemas: PatchBusinessBusinessOwnerRelationship, PatchPersonBusinessOwnerRelationship, PatchPersonBusinessRelationship. Details: " + ", ".join(error_messages))
        elif match == 0:
            # no match
            raise ValueError("No match found when deserializing the JSON string into PatchRelationshipIn with oneOf schemas: PatchBusinessBusinessOwnerRelationship, PatchPersonBusinessOwnerRelationship, PatchPersonBusinessRelationship. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())





