# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.address import Address

class PatchCustomer(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    dob: Optional[date] = Field(None, description="Customer's date of birth in RFC 3339 full-date format (YYYY-MM-DD)")
    email: Optional[StrictStr] = Field(None, description="Customer's email")
    first_name: Optional[StrictStr] = Field(None, description="Customer's first name")
    last_name: Optional[StrictStr] = Field(None, description="Customer's last name")
    legal_address: Optional[Address] = None
    metadata: Optional[Dict[str, Any]] = Field(None, description="User-supplied JSON format metadata. Do not use to store PII.")
    middle_name: Optional[StrictStr] = Field(None, description="Customer's middle name")
    phone_number: Optional[constr(strict=True)] = Field(None, description="Customer's mobile phone number with country code in E.164 format. Must have a valid country code. Area code and local phone number are not validated.")
    shipping_address: Optional[Address] = None
    ssn: Optional[StrictStr] = Field(None, description="Customer's full tax ID eg SSN formatted with hyphens. This optional parameter is required when running KYC on a customer. Must be compiled with ^\\d{3}-\\d{2}-\\d{4}$. Response contains the last 4 digits only (e.g. 6789).")
    status: Optional[StrictStr] = Field(None, description="Customer's status")
    __properties = ["dob", "email", "first_name", "last_name", "legal_address", "metadata", "middle_name", "phone_number", "shipping_address", "ssn", "status"]

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('ACTIVE', 'ESCHEAT', 'DECEASED', 'DENIED', 'DORMANT', 'FROZEN', 'INACTIVE', 'PROSPECT', 'SANCTION'):
            raise ValueError("must validate the enum values ('ACTIVE', 'ESCHEAT', 'DECEASED', 'DENIED', 'DORMANT', 'FROZEN', 'INACTIVE', 'PROSPECT', 'SANCTION')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> PatchCustomer:
        """Create an instance of PatchCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of legal_address
        if self.legal_address:
            _dict['legal_address'] = self.legal_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of shipping_address
        if self.shipping_address:
            _dict['shipping_address'] = self.shipping_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> PatchCustomer:
        """Create an instance of PatchCustomer from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return PatchCustomer.parse_obj(obj)

        _obj = PatchCustomer.parse_obj({
            "dob": obj.get("dob"),
            "email": obj.get("email"),
            "first_name": obj.get("first_name"),
            "last_name": obj.get("last_name"),
            "legal_address": Address.from_dict(obj.get("legal_address")) if obj.get("legal_address") is not None else None,
            "metadata": obj.get("metadata"),
            "middle_name": obj.get("middle_name"),
            "phone_number": obj.get("phone_number"),
            "shipping_address": Address.from_dict(obj.get("shipping_address")) if obj.get("shipping_address") is not None else None,
            "ssn": obj.get("ssn"),
            "status": obj.get("status")
        })
        return _obj

