# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator
from synctera_client.models.ach_request_hold_data import AchRequestHoldData
from synctera_client.models.risk_data import RiskData

class OutgoingAchRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: StrictInt = Field(..., description="Amount to transfer in ISO 4217 minor currency units")
    company_entry_description: Optional[constr(strict=True, max_length=10)] = Field(None, description="Company entry description ACH field. Originator inserts this field's value to provide the Receiver with a description of the entry's purpose.")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    customer_id: StrictStr = Field(..., description="The customer's unique identifier")
    dc_sign: StrictStr = Field(..., description="The type of transaction (debit or credit). A debit is a transfer in and a credit is a transfer out of the originating account")
    effective_date: Optional[date] = Field(None, description="Effective date transaction proccesses (is_same_day needs to be false or not present at all)")
    external_data: Optional[Dict[str, Any]] = Field(None, description="Additional transfer metadata structured as key-value pairs")
    final_customer_id: Optional[StrictStr] = Field(None, description="ID of the international customer that receives the final remittance transfer (required for OFAC enabled payments)")
    hold: Optional[AchRequestHoldData] = None
    id: Optional[StrictStr] = None
    is_same_day: Optional[StrictBool] = Field(None, description="Send as same day ACH transaction (use only is_same_day without specific effective_date)")
    memo: Optional[StrictStr] = Field(None, description="Memo for the payment")
    originating_account_id: StrictStr = Field(..., description="The unique identifier for an originating account")
    receiving_account_id: StrictStr = Field(..., description="The unique identifier for an receiving account")
    reference_info: Optional[StrictStr] = Field(None, description="Will be sent to the ACH network and maps to Addenda record 05 - the recipient bank will receive this info")
    risk: Optional[RiskData] = None
    __properties = ["amount", "company_entry_description", "currency", "customer_id", "dc_sign", "effective_date", "external_data", "final_customer_id", "hold", "id", "is_same_day", "memo", "originating_account_id", "receiving_account_id", "reference_info", "risk"]

    @validator('dc_sign')
    def dc_sign_validate_enum(cls, v):
        if v not in ('debit', 'credit'):
            raise ValueError("must validate the enum values ('debit', 'credit')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OutgoingAchRequest:
        """Create an instance of OutgoingAchRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of hold
        if self.hold:
            _dict['hold'] = self.hold.to_dict()
        # override the default output from pydantic by calling `to_dict()` of risk
        if self.risk:
            _dict['risk'] = self.risk.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OutgoingAchRequest:
        """Create an instance of OutgoingAchRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OutgoingAchRequest.parse_obj(obj)

        _obj = OutgoingAchRequest.parse_obj({
            "amount": obj.get("amount"),
            "company_entry_description": obj.get("company_entry_description"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "dc_sign": obj.get("dc_sign"),
            "effective_date": obj.get("effective_date"),
            "external_data": obj.get("external_data"),
            "final_customer_id": obj.get("final_customer_id"),
            "hold": AchRequestHoldData.from_dict(obj.get("hold")) if obj.get("hold") is not None else None,
            "id": obj.get("id"),
            "is_same_day": obj.get("is_same_day"),
            "memo": obj.get("memo"),
            "originating_account_id": obj.get("originating_account_id"),
            "receiving_account_id": obj.get("receiving_account_id"),
            "reference_info": obj.get("reference_info"),
            "risk": RiskData.from_dict(obj.get("risk")) if obj.get("risk") is not None else None
        })
        return _obj

