# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator
from synctera_client.models.card_acceptor_model import CardAcceptorModel
from synctera_client.models.original_credit_sender_data import OriginalCreditSenderData

class OriginalCreditRequestModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: StrictInt = Field(..., description="The amount of the transaction in the smallest whole denomination of the applicable currency (eg. For USD use cents)")
    card_acceptor: Optional[CardAcceptorModel] = None
    card_id: StrictStr = ...
    mid: constr(strict=True, max_length=50, min_length=1) = ...
    screening_score: Optional[StrictStr] = None
    sender_data: Optional[OriginalCreditSenderData] = None
    transaction_purpose: Optional[StrictStr] = Field(None, alias="transactionPurpose")
    type: StrictStr = ...
    __properties = ["amount", "card_acceptor", "card_id", "mid", "screening_score", "sender_data", "transactionPurpose", "type"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('account_to_account', 'person_to_person', 'prepaid', 'wallet_transfer', 'money_transfer_by_bank', 'business_to_business', 'disbursement', 'government_disbursement', 'gambling_payout', 'loyalty', 'merchant_disbursement', 'online_gambling_payout', 'pension_disbursement', 'prepaid_loads', 'card_bill_payment', 'bill_payment', 'cash_claim', 'cash_in', 'cash_out', 'mobile_air_time_payment', 'money_transfer_by_merchant', 'face_to_face_merchant_payment', 'government_payment', 'payments_goods_services'):
            raise ValueError("must validate the enum values ('account_to_account', 'person_to_person', 'prepaid', 'wallet_transfer', 'money_transfer_by_bank', 'business_to_business', 'disbursement', 'government_disbursement', 'gambling_payout', 'loyalty', 'merchant_disbursement', 'online_gambling_payout', 'pension_disbursement', 'prepaid_loads', 'card_bill_payment', 'bill_payment', 'cash_claim', 'cash_in', 'cash_out', 'mobile_air_time_payment', 'money_transfer_by_merchant', 'face_to_face_merchant_payment', 'government_payment', 'payments_goods_services')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> OriginalCreditRequestModel:
        """Create an instance of OriginalCreditRequestModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of card_acceptor
        if self.card_acceptor:
            _dict['card_acceptor'] = self.card_acceptor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of sender_data
        if self.sender_data:
            _dict['sender_data'] = self.sender_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> OriginalCreditRequestModel:
        """Create an instance of OriginalCreditRequestModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return OriginalCreditRequestModel.parse_obj(obj)

        _obj = OriginalCreditRequestModel.parse_obj({
            "amount": obj.get("amount"),
            "card_acceptor": CardAcceptorModel.from_dict(obj.get("card_acceptor")) if obj.get("card_acceptor") is not None else None,
            "card_id": obj.get("card_id"),
            "mid": obj.get("mid"),
            "screening_score": obj.get("screening_score"),
            "sender_data": OriginalCreditSenderData.from_dict(obj.get("sender_data")) if obj.get("sender_data") is not None else None,
            "transaction_purpose": obj.get("transactionPurpose"),
            "type": obj.get("type")
        })
        return _obj

