# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.monitoring_status import MonitoringStatus
from synctera_client.models.vendor_info import VendorInfo

class MonitoringAlert(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="Unique ID for the business. Exactly one of `business_id` or `person_id` must be set. ")
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    id: Optional[StrictStr] = Field(None, description="Unique identifier for this alert.")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last update.")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    person_id: Optional[StrictStr] = Field(None, description="Unique ID for the person. Exactly one of `person_id` or `business_id` must be set. ")
    status: Optional[MonitoringStatus] = None
    type: Optional[StrictStr] = Field(None, description="The type of customer alert. Any of the following: * `WATCHLIST` – the customer was added to a known watchlist. * `BANKRUPTCY` – the customer filed for bankruptcy. ")
    urls: Optional[List[StrictStr]] = Field(None, description="Where to get more information about this alert.")
    vendor_info: Optional[VendorInfo] = None
    __properties = ["business_id", "creation_time", "id", "last_updated_time", "metadata", "person_id", "status", "type", "urls", "vendor_info"]

    @validator('type')
    def type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('WATCHLIST', 'BANKRUPTCY'):
            raise ValueError("must validate the enum values ('WATCHLIST', 'BANKRUPTCY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> MonitoringAlert:
        """Create an instance of MonitoringAlert from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                            "type",
                            "urls",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of vendor_info
        if self.vendor_info:
            _dict['vendor_info'] = self.vendor_info.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> MonitoringAlert:
        """Create an instance of MonitoringAlert from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return MonitoringAlert.parse_obj(obj)

        _obj = MonitoringAlert.parse_obj({
            "business_id": obj.get("business_id"),
            "creation_time": obj.get("creation_time"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "person_id": obj.get("person_id"),
            "status": obj.get("status"),
            "type": obj.get("type"),
            "urls": obj.get("urls"),
            "vendor_info": VendorInfo.from_dict(obj.get("vendor_info")) if obj.get("vendor_info") is not None else None
        })
        return _obj

