# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator
from synctera_client.models.base_transaction_decline import BaseTransactionDecline
from synctera_client.models.enhanced_transaction_data import EnhancedTransactionData
from synctera_client.models.internal_transfer_transaction_data import InternalTransferTransactionData
from synctera_client.models.internal_transfer_transaction_subtypes import InternalTransferTransactionSubtypes

class InternalTransferTransaction(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: Optional[StrictStr] = Field(None, description="The account uuid associated with the transaction. `account_id` and `internal_account_id` are mutually exclusive")
    amount: StrictInt = Field(..., description="The total amount of the transaction including both pending and already posted amounts. The value is represented as the smallest denomination of the applicable currency.")
    creation_time: datetime = Field(..., description="The exact time the transaction was recorded in the ledger")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    customer_id: Optional[StrictStr] = Field(None, description="The uuid of the customer that initiated the transaction (if any) ")
    dc_sign: StrictStr = Field(..., description="The `dc_sign` represents the direction money was moved. A value of `DEBIT` is money moving out of an account, a value of `CREDIT` is money moving into an account")
    decline: Optional[BaseTransactionDecline] = None
    description: Optional[StrictStr] = Field(None, description="A human-friendly description of the transaction, provided by the integrator")
    effective_date: date = Field(..., description="The effective date of the transaction. This usually aligns with network settlement date, which differs between transaction types. The effective date is also used to determine effective daily balances for the purposes of interest calculation.")
    enhanced_transaction: Optional[EnhancedTransactionData] = None
    force_post: StrictBool = Field(..., description="Determines whether or not a transaction or auth was \"forced\" or not. A forced transaction skips any account balance checks")
    group_id: StrictStr = Field(..., description="The group id of the transaction. Every transaction in the ledger is one entry in a double-entry system and the primary and offset transactions share the same `group_id`")
    hold_expiration_time: Optional[datetime] = Field(None, description="The date and time any pending amount is expected to be released back to the account.")
    id: StrictStr = Field(..., description="The unique identifier of the transaction")
    internal_account_id: Optional[StrictStr] = Field(None, description="The internal account uuid associated with the transaction. `account_id` and `internal_account_id` are mutually exclusive")
    last_updated_time: datetime = Field(..., description="The date and time the transaction was last modified")
    partial_hold: StrictBool = Field(..., description="Determines whether or not the funds on hold were the result of a partial auth or not. If `true` the `pending_amount` of the transaction will be less than the requested amount. This is primarily used for certain types of card transactions.")
    pending_amount: StrictInt = Field(..., description="The amount amount of the transaction currently authorized or on hold")
    posted_amount: StrictInt = Field(..., description="The amount of the transaction that has been fully posted to the account")
    posted_date: Optional[date] = Field(None, description="The date the transaction was posted (based on the bank calendar and end-of-day). For transaction with multiple postings, this is the date of the earliest posting. This will be omitted for transactions with a `posted_amount` of `0`.")
    reference_id: Optional[StrictStr] = Field(None, description="An external ID provided by the payment network to represent this transaction. This is not guaranteed to be globally unique. This will always be omitted for internal transfers.")
    status: StrictStr = Field(..., description="The status of the transaction")
    system_description: Optional[StrictStr] = Field(None, description="A human-friendly description of the transaction, provided by the Synctera platform")
    transaction_time: datetime = Field(..., description="The time the transaction occurred. In most cases this will be roughly identical to creation_time, but it can differ in some situations if the payment doesn't appear in the ledger in real-time.")
    type: StrictStr = Field(..., description="The type of the transaction. This typically represents the \"payment\" rail that is used. For example, for ACH payments this will be `ach`, while debit card transactions will use `card`.")
    internal_transfer_transaction: Optional[InternalTransferTransactionData] = None
    subtype: InternalTransferTransactionSubtypes = ...
    __properties = ["account_id", "amount", "creation_time", "currency", "customer_id", "dc_sign", "decline", "description", "effective_date", "enhanced_transaction", "force_post", "group_id", "hold_expiration_time", "id", "internal_account_id", "last_updated_time", "partial_hold", "pending_amount", "posted_amount", "posted_date", "reference_id", "status", "system_description", "transaction_time", "type", "internal_transfer_transaction", "subtype"]

    @validator('dc_sign')
    def dc_sign_validate_enum(cls, v):
        if v not in ('DEBIT', 'CREDIT'):
            raise ValueError("must validate the enum values ('DEBIT', 'CREDIT')")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('PENDING', 'DECLINED', 'COMPLETE'):
            raise ValueError("must validate the enum values ('PENDING', 'DECLINED', 'COMPLETE')")
        return v

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('ACH', 'CARD', 'CHECK', 'EXTERNAL_CARD', 'INTERNAL_TRANSFER', 'WIRE'):
            raise ValueError("must validate the enum values ('ACH', 'CARD', 'CHECK', 'EXTERNAL_CARD', 'INTERNAL_TRANSFER', 'WIRE')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> InternalTransferTransaction:
        """Create an instance of InternalTransferTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of decline
        if self.decline:
            _dict['decline'] = self.decline.to_dict()
        # override the default output from pydantic by calling `to_dict()` of enhanced_transaction
        if self.enhanced_transaction:
            _dict['enhanced_transaction'] = self.enhanced_transaction.to_dict()
        # override the default output from pydantic by calling `to_dict()` of internal_transfer_transaction
        if self.internal_transfer_transaction:
            _dict['internal_transfer_transaction'] = self.internal_transfer_transaction.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> InternalTransferTransaction:
        """Create an instance of InternalTransferTransaction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return InternalTransferTransaction.parse_obj(obj)

        _obj = InternalTransferTransaction.parse_obj({
            "account_id": obj.get("account_id"),
            "amount": obj.get("amount"),
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "dc_sign": obj.get("dc_sign"),
            "decline": BaseTransactionDecline.from_dict(obj.get("decline")) if obj.get("decline") is not None else None,
            "description": obj.get("description"),
            "effective_date": obj.get("effective_date"),
            "enhanced_transaction": EnhancedTransactionData.from_dict(obj.get("enhanced_transaction")) if obj.get("enhanced_transaction") is not None else None,
            "force_post": obj.get("force_post"),
            "group_id": obj.get("group_id"),
            "hold_expiration_time": obj.get("hold_expiration_time"),
            "id": obj.get("id"),
            "internal_account_id": obj.get("internal_account_id"),
            "last_updated_time": obj.get("last_updated_time"),
            "partial_hold": obj.get("partial_hold"),
            "pending_amount": obj.get("pending_amount"),
            "posted_amount": obj.get("posted_amount"),
            "posted_date": obj.get("posted_date"),
            "reference_id": obj.get("reference_id"),
            "status": obj.get("status"),
            "system_description": obj.get("system_description"),
            "transaction_time": obj.get("transaction_time"),
            "type": obj.get("type"),
            "internal_transfer_transaction": InternalTransferTransactionData.from_dict(obj.get("internal_transfer_transaction")) if obj.get("internal_transfer_transaction") is not None else None,
            "subtype": obj.get("subtype")
        })
        return _obj

