# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.accrual_payout_schedule import AccrualPayoutSchedule
from synctera_client.models.calculation_method import CalculationMethod
from synctera_client.models.rate_details import RateDetails

class Interest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    accrual_payout_schedule: AccrualPayoutSchedule = ...
    calculation_method: CalculationMethod = ...
    description: Optional[StrictStr] = Field(None, description="User provided description for the current interest.")
    id: Optional[StrictStr] = Field(None, description="Interest ID")
    product_type: StrictStr = ...
    rates: List[RateDetails] = Field(..., description="A list of interest rate. Date intervals between valid_from and valid_to expect to have no overlap. ")
    __properties = ["accrual_payout_schedule", "calculation_method", "description", "id", "product_type", "rates"]

    @validator('product_type')
    def product_type_validate_enum(cls, v):
        if v not in ('INTEREST', 'FEE'):
            raise ValueError("must validate the enum values ('INTEREST', 'FEE')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Interest:
        """Create an instance of Interest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in rates (list)
        _items = []
        if self.rates:
            for _item in self.rates:
                if _item:
                    _items.append(_item.to_dict())
            _dict['rates'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Interest:
        """Create an instance of Interest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Interest.parse_obj(obj)

        _obj = Interest.parse_obj({
            "accrual_payout_schedule": obj.get("accrual_payout_schedule"),
            "calculation_method": obj.get("calculation_method"),
            "description": obj.get("description"),
            "id": obj.get("id"),
            "product_type": obj.get("product_type"),
            "rates": [RateDetails.from_dict(_item) for _item in obj.get("rates")] if obj.get("rates") is not None else None
        })
        return _obj

