# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr

class HoldDeclineRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_no: StrictStr = Field(..., description="The account number associated with the hold")
    external_data: Optional[Dict[str, Any]] = Field(None, description="an unstructured json blob representing additional transaction information supplied by the integrator.")
    reason: StrictStr = Field(..., description="The reason for the cancellation")
    reference_id: StrictStr = Field(..., description="An external ID provided by the payment network to represent this transaction. This will always be null for internal transfers.")
    risk_info: Optional[Dict[str, Any]] = Field(None, description="Information received by the transaction risk/fraud service related to this transaction")
    user_data: Optional[Dict[str, Any]] = Field(None, description="An unstructured JSON blob representing additional transaction information specific to each payment rail.")
    __properties = ["account_no", "external_data", "reason", "reference_id", "risk_info", "user_data"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HoldDeclineRequest:
        """Create an instance of HoldDeclineRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if external_data (nullable) is None
        if self.external_data is None:
            _dict['external_data'] = None

        # set to None if risk_info (nullable) is None
        if self.risk_info is None:
            _dict['risk_info'] = None

        # set to None if user_data (nullable) is None
        if self.user_data is None:
            _dict['user_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HoldDeclineRequest:
        """Create an instance of HoldDeclineRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return HoldDeclineRequest.parse_obj(obj)

        _obj = HoldDeclineRequest.parse_obj({
            "account_no": obj.get("account_no"),
            "external_data": obj.get("external_data"),
            "reason": obj.get("reason"),
            "reference_id": obj.get("reference_id"),
            "risk_info": obj.get("risk_info"),
            "user_data": obj.get("user_data")
        })
        return _obj

