# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, conint
from synctera_client.models.dc_sign import DcSign
from synctera_client.models.hold_create_request_status import HoldCreateRequestStatus

class HoldCreateRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_id: Optional[StrictStr] = Field(None, description="The uuid of the account associated with the hold. Note: account_no and account_id are mutually exclusive")
    account_no: Optional[StrictStr] = Field(None, description="The account number associated with the hold")
    allow_partial: StrictBool = ...
    amount: conint(strict=True, ge=0) = Field(..., description="The amount of the hold.")
    auto_post_at: datetime = Field(..., description="The time the transaction will be automatically posted.")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    dc_sign: DcSign = ...
    decline_reason: StrictStr = Field(..., description="The reason for the decline, if any")
    description: Optional[StrictStr] = Field(None, description="The description of the transaction")
    effective_date: datetime = Field(..., description="The effective date of the transaction once it gets posted")
    enhanced_transaction: Optional[Dict[str, Any]] = Field(None, description="An unstructured JSON blob representing additional transaction information specific to each payment rail.")
    expires_at: datetime = Field(..., description="The date that at which this hold is no longer valid.")
    external_data: Optional[Dict[str, Any]] = Field(None, description="an unstructured json blob representing additional transaction information supplied by the integrator.")
    force_post: StrictBool = Field(..., description="Whether or not the hold was forced (spending controls ignored)")
    memo: StrictStr = Field(..., description="A short note to the recipient")
    network: StrictStr = Field(..., description="The network this transaction is associated with")
    offset_account_id: Optional[StrictStr] = Field(None, description="The uuid of the account to offset the transaction Note: `offset_account_id` and `account_id` are mutually exclusive.")
    offset_account_no: Optional[StrictStr] = Field(None, description="The account number to offset the transaction")
    offset_description: Optional[StrictStr] = Field(None, description="The description of the offset transaction")
    reference_id: StrictStr = Field(..., description="An external ID provided by the payment network to represent this transaction. This will always be null for internal transfers.")
    status: HoldCreateRequestStatus = ...
    subtype: StrictStr = Field(..., description="The specific transaction type. For example, for `ach`, this may be \"outgoing_debit\".")
    transaction_time: datetime = Field(..., description="The time the transaction occurred.")
    type: StrictStr = Field(..., description="The general type of transaction. For example, \"card\" or \"ach\".")
    user_data: Optional[Dict[str, Any]] = Field(None, description="An unstructured JSON blob representing additional transaction information specific to each payment rail.")
    __properties = ["account_id", "account_no", "allow_partial", "amount", "auto_post_at", "currency", "dc_sign", "decline_reason", "description", "effective_date", "enhanced_transaction", "expires_at", "external_data", "force_post", "memo", "network", "offset_account_id", "offset_account_no", "offset_description", "reference_id", "status", "subtype", "transaction_time", "type", "user_data"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> HoldCreateRequest:
        """Create an instance of HoldCreateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if enhanced_transaction (nullable) is None
        if self.enhanced_transaction is None:
            _dict['enhanced_transaction'] = None

        # set to None if external_data (nullable) is None
        if self.external_data is None:
            _dict['external_data'] = None

        # set to None if user_data (nullable) is None
        if self.user_data is None:
            _dict['user_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> HoldCreateRequest:
        """Create an instance of HoldCreateRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return HoldCreateRequest.parse_obj(obj)

        _obj = HoldCreateRequest.parse_obj({
            "account_id": obj.get("account_id"),
            "account_no": obj.get("account_no"),
            "allow_partial": obj.get("allow_partial"),
            "amount": obj.get("amount"),
            "auto_post_at": obj.get("auto_post_at"),
            "currency": obj.get("currency"),
            "dc_sign": obj.get("dc_sign"),
            "decline_reason": obj.get("decline_reason"),
            "description": obj.get("description"),
            "effective_date": obj.get("effective_date"),
            "enhanced_transaction": obj.get("enhanced_transaction"),
            "expires_at": obj.get("expires_at"),
            "external_data": obj.get("external_data"),
            "force_post": obj.get("force_post"),
            "memo": obj.get("memo"),
            "network": obj.get("network"),
            "offset_account_id": obj.get("offset_account_id"),
            "offset_account_no": obj.get("offset_account_no"),
            "offset_description": obj.get("offset_description"),
            "reference_id": obj.get("reference_id"),
            "status": obj.get("status"),
            "subtype": obj.get("subtype"),
            "transaction_time": obj.get("transaction_time"),
            "type": obj.get("type"),
            "user_data": obj.get("user_data")
        })
        return _obj

