# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.push_tokenize_request_data import PushTokenizeRequestData

class GoogleDigitalWalletProvisionResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    card_id: Optional[StrictStr] = Field(None, description="The unique identifier of a card")
    created_time: Optional[datetime] = None
    last_modified_time: Optional[datetime] = None
    push_tokenize_request_data: Optional[PushTokenizeRequestData] = None
    __properties = ["card_id", "created_time", "last_modified_time", "push_tokenize_request_data"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> GoogleDigitalWalletProvisionResponse:
        """Create an instance of GoogleDigitalWalletProvisionResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of push_tokenize_request_data
        if self.push_tokenize_request_data:
            _dict['push_tokenize_request_data'] = self.push_tokenize_request_data.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> GoogleDigitalWalletProvisionResponse:
        """Create an instance of GoogleDigitalWalletProvisionResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return GoogleDigitalWalletProvisionResponse.parse_obj(obj)

        _obj = GoogleDigitalWalletProvisionResponse.parse_obj({
            "card_id": obj.get("card_id"),
            "created_time": obj.get("created_time"),
            "last_modified_time": obj.get("last_modified_time"),
            "push_tokenize_request_data": PushTokenizeRequestData.from_dict(obj.get("push_tokenize_request_data")) if obj.get("push_tokenize_request_data") is not None else None
        })
        return _obj

