# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

class Fee(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: StrictInt = Field(..., description="Fee amount")
    currency: constr(strict=True) = Field(..., description="Fee currency code in ISO 4217")
    fee_type: StrictStr = Field(..., description="Fee type")
    id: Optional[StrictStr] = Field(None, description="Fee ID")
    product_type: StrictStr = ...
    __properties = ["amount", "currency", "fee_type", "id", "product_type"]

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    @validator('fee_type')
    def fee_type_validate_enum(cls, v):
        if v not in ('MONTHLY_FEE', 'ANNUAL_FEE', 'ATM_WITHDRWAL_FEE', 'OVERDRAFT_FEE', 'ACH_FEE', 'WIRE_FEE'):
            raise ValueError("must validate the enum values ('MONTHLY_FEE', 'ANNUAL_FEE', 'ATM_WITHDRWAL_FEE', 'OVERDRAFT_FEE', 'ACH_FEE', 'WIRE_FEE')")
        return v

    @validator('product_type')
    def product_type_validate_enum(cls, v):
        if v not in ('INTEREST', 'FEE'):
            raise ValueError("must validate the enum values ('INTEREST', 'FEE')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Fee:
        """Create an instance of Fee from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Fee:
        """Create an instance of Fee from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Fee.parse_obj(obj)

        _obj = Fee.parse_obj({
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "fee_type": obj.get("fee_type"),
            "id": obj.get("id"),
            "product_type": obj.get("product_type")
        })
        return _obj

