# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json



from pydantic import BaseModel, Field, StrictBool, StrictStr, validator

class ExternalCardVerifications(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    address_verification_result: StrictStr = Field(..., description="Address verification results  Status | Description --- | --- VERIFIED | AVS verified NOT_VERIFIED | AVS not verified ADDRESS_MISMATCH | ZIP code match, address no match ZIP_MISMATCH | Address match, ZIP code no match ADDRESS_AND_ZIP_MISMATCH | Address and ZIP code no match ")
    cvv2_result: StrictStr = Field(..., description="Card Verification Value results  Status | Description --- | --- VERIFIED | CVV and expiration date verified NOT_VERIFIED | CVV and expiration date not verified CVV_MISMATCH | Either CVV or expiration date does not match NOT_SUPPORTED | Issuer does not participate in CVV2 service ")
    pull_enabled: StrictBool = Field(..., description="Indicates if the card is able to perform PULL transfers.")
    push_enabled: StrictBool = Field(..., description="Indicates if the card is able to perform PUSH transfers.")
    state: StrictStr = ...
    __properties = ["address_verification_result", "cvv2_result", "pull_enabled", "push_enabled", "state"]

    @validator('address_verification_result')
    def address_verification_result_validate_enum(cls, v):
        if v not in ('VERIFIED', 'NOT_VERIFIED', 'ADDRESS_MISMATCH', 'ZIP_MISMATCH', 'ADDRESS_AND_ZIP_MISMATCH'):
            raise ValueError("must validate the enum values ('VERIFIED', 'NOT_VERIFIED', 'ADDRESS_MISMATCH', 'ZIP_MISMATCH', 'ADDRESS_AND_ZIP_MISMATCH')")
        return v

    @validator('cvv2_result')
    def cvv2_result_validate_enum(cls, v):
        if v not in ('VERIFIED', 'NOT_VERIFIED', 'CVV_MISMATCH', 'NOT_SUPPORTED'):
            raise ValueError("must validate the enum values ('VERIFIED', 'NOT_VERIFIED', 'CVV_MISMATCH', 'NOT_SUPPORTED')")
        return v

    @validator('state')
    def state_validate_enum(cls, v):
        if v not in ('SUCCEEDED', 'FAILED'):
            raise ValueError("must validate the enum values ('SUCCEEDED', 'FAILED')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalCardVerifications:
        """Create an instance of ExternalCardVerifications from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalCardVerifications:
        """Create an instance of ExternalCardVerifications from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalCardVerifications.parse_obj(obj)

        _obj = ExternalCardVerifications.parse_obj({
            "address_verification_result": obj.get("address_verification_result"),
            "cvv2_result": obj.get("cvv2_result"),
            "pull_enabled": obj.get("pull_enabled"),
            "push_enabled": obj.get("push_enabled"),
            "state": obj.get("state")
        })
        return _obj

