# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from synctera_client.models.external_card_verifications import ExternalCardVerifications

class ExternalCardResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    created_time: Optional[datetime] = None
    currency: constr(strict=True, max_length=3, min_length=3) = Field(..., description="ISO 4217  Alpha-3 currency code")
    customer_id: StrictStr = Field(..., description="The unique identifier of a customer")
    expiration_month: StrictStr = ...
    expiration_year: StrictStr = ...
    id: StrictStr = Field(..., description="External card ID")
    last_four: StrictStr = Field(..., description="The last 4 digits of the card PAN")
    last_modified_time: Optional[datetime] = None
    name: StrictStr = Field(..., description="The cardholder name")
    verifications: Optional[ExternalCardVerifications] = None
    __properties = ["created_time", "currency", "customer_id", "expiration_month", "expiration_year", "id", "last_four", "last_modified_time", "name", "verifications"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalCardResponse:
        """Create an instance of ExternalCardResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "expiration_month",
                            "expiration_year",
                            "last_four",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of verifications
        if self.verifications:
            _dict['verifications'] = self.verifications.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalCardResponse:
        """Create an instance of ExternalCardResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalCardResponse.parse_obj(obj)

        _obj = ExternalCardResponse.parse_obj({
            "created_time": obj.get("created_time"),
            "currency": obj.get("currency"),
            "customer_id": obj.get("customer_id"),
            "expiration_month": obj.get("expiration_month"),
            "expiration_year": obj.get("expiration_year"),
            "id": obj.get("id"),
            "last_four": obj.get("last_four"),
            "last_modified_time": obj.get("last_modified_time"),
            "name": obj.get("name"),
            "verifications": ExternalCardVerifications.from_dict(obj.get("verifications")) if obj.get("verifications") is not None else None
        })
        return _obj

