# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date
from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, validator

class ExternalAccountTransaction(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: Optional[StrictInt] = Field(None, description="Transaction amount. Number in cents. E.g. 1000 represents $10.00")
    authorized_date: Optional[date] = Field(None, description="Date that the transaction is authorized. ISO 8601 format ( YYYY-MM-DD ).")
    category: Optional[List[StrictStr]] = Field(None, description="Category of the transaction")
    check_number: Optional[StrictStr] = Field(None, description="Check number of the transaction. This field will be null if not a check transaction.")
    currency: Optional[StrictStr] = Field(None, description="ISO 4217 alphabetic currency code")
    var_date: Optional[date] = Field(None, alias="date", description="For pending transactions, this represents the date of the transaction occurred; for posted transactions, this represents the date of the transaction posted. ISO 8601 format ( YYYY-MM-DD ). ")
    is_pending: Optional[StrictBool] = Field(None, description="Indicates the transaction is pending or unsettled if true.")
    merchant_name: Optional[StrictStr] = Field(None, description="Merchant name of the transaction")
    payment_channel: Optional[StrictStr] = Field(None, description="channel used to make a payment")
    payment_method: Optional[StrictStr] = Field(None, description="Transfer type of the transaction, e.g. ACH")
    transaction_id: Optional[StrictStr] = Field(None, description="case-sensitive transaction ID")
    __properties = ["amount", "authorized_date", "category", "check_number", "currency", "date", "is_pending", "merchant_name", "payment_channel", "payment_method", "transaction_id"]

    @validator('payment_channel')
    def payment_channel_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('IN_STORE', 'ONLINE', 'OTHER'):
            raise ValueError("must validate the enum values ('IN_STORE', 'ONLINE', 'OTHER')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalAccountTransaction:
        """Create an instance of ExternalAccountTransaction from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if authorized_date (nullable) is None
        if self.authorized_date is None:
            _dict['authorized_date'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalAccountTransaction:
        """Create an instance of ExternalAccountTransaction from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalAccountTransaction.parse_obj(obj)

        _obj = ExternalAccountTransaction.parse_obj({
            "amount": obj.get("amount"),
            "authorized_date": obj.get("authorized_date"),
            "category": obj.get("category"),
            "check_number": obj.get("check_number"),
            "currency": obj.get("currency"),
            "var_date": obj.get("date"),
            "is_pending": obj.get("is_pending"),
            "merchant_name": obj.get("merchant_name"),
            "payment_channel": obj.get("payment_channel"),
            "payment_method": obj.get("payment_method"),
            "transaction_id": obj.get("transaction_id")
        })
        return _obj

