# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr

class ExternalAccountAccessToken(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="The identifier for the business customer associated with this external account. Exactly one of `business_id` or `customer_id` must be specified. ")
    customer_id: Optional[StrictStr] = Field(None, description="The identifier for the personal customer associated with this external account. Exactly one of `customer_id` or `business_id` must be specified. ")
    request_id: Optional[StrictStr] = Field(None, description="A unique identifier for the request, which can be used for troubleshooting")
    vendor_access_token: Optional[StrictStr] = Field(None, description="The access token associated with the Item data is being requested for.")
    vendor_customer_id: Optional[StrictStr] = Field(None, description="An alias for `customer_id` (deprecated).")
    vendor_institution_id: constr(strict=True, min_length=1) = Field(..., description="The ID of the institution the access token is requested for ")
    vendor_public_token: StrictStr = Field(..., description="The user's public token obtained from successful link login. ")
    __properties = ["business_id", "customer_id", "request_id", "vendor_access_token", "vendor_customer_id", "vendor_institution_id", "vendor_public_token"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalAccountAccessToken:
        """Create an instance of ExternalAccountAccessToken from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "request_id",
                            "vendor_access_token",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalAccountAccessToken:
        """Create an instance of ExternalAccountAccessToken from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalAccountAccessToken.parse_obj(obj)

        _obj = ExternalAccountAccessToken.parse_obj({
            "business_id": obj.get("business_id"),
            "customer_id": obj.get("customer_id"),
            "request_id": obj.get("request_id"),
            "vendor_access_token": obj.get("vendor_access_token"),
            "vendor_customer_id": obj.get("vendor_customer_id"),
            "vendor_institution_id": obj.get("vendor_institution_id"),
            "vendor_public_token": obj.get("vendor_public_token")
        })
        return _obj

