# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictStr, validator
from synctera_client.models.account_identifiers import AccountIdentifiers
from synctera_client.models.account_routing import AccountRouting
from synctera_client.models.account_verification import AccountVerification
from synctera_client.models.external_account_vendor_data import ExternalAccountVendorData
from synctera_client.models.vendor_info import VendorInfo

class ExternalAccount(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    account_identifiers: AccountIdentifiers = ...
    account_owner_names: List[StrictStr] = Field(..., description="The names of the account owners. Values may be masked, in which case the array will be empty. ")
    business_id: Optional[StrictStr] = Field(None, description="The identifier for the business customer associated with this external account. Exactly one of `business_id` or `customer_id` will be returned. ")
    creation_time: datetime = ...
    customer_id: Optional[StrictStr] = Field(None, description="The identifier for the personal customer associated with this external account. Exactly one of `customer_id` or `business_id` will be returned. ")
    deletion_time: Optional[datetime] = None
    id: StrictStr = Field(..., description="External account unique identifier")
    last_updated_time: datetime = ...
    metadata: Optional[Dict[str, Any]] = Field(None, description="User-supplied JSON format metadata.")
    name: Optional[StrictStr] = Field(None, description="The official name of the account")
    nickname: Optional[StrictStr] = Field(None, description="A user-meaningful name for the account")
    routing_identifiers: AccountRouting = ...
    status: StrictStr = Field(..., description="The current state of the account")
    type: StrictStr = Field(..., description="The type of the account")
    vendor_data: Optional[ExternalAccountVendorData] = None
    vendor_info: Optional[VendorInfo] = None
    verification: Optional[AccountVerification] = ...
    __properties = ["account_identifiers", "account_owner_names", "business_id", "creation_time", "customer_id", "deletion_time", "id", "last_updated_time", "metadata", "name", "nickname", "routing_identifiers", "status", "type", "vendor_data", "vendor_info", "verification"]

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('ACTIVE', 'CLOSED'):
            raise ValueError("must validate the enum values ('ACTIVE', 'CLOSED')")
        return v

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('CHECKING', 'SAVINGS', 'CREDIT_CARD', 'MONEY_MARKET', 'INVESTMENT_529', 'OTHER'):
            raise ValueError("must validate the enum values ('CHECKING', 'SAVINGS', 'CREDIT_CARD', 'MONEY_MARKET', 'INVESTMENT_529', 'OTHER')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ExternalAccount:
        """Create an instance of ExternalAccount from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of account_identifiers
        if self.account_identifiers:
            _dict['account_identifiers'] = self.account_identifiers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of routing_identifiers
        if self.routing_identifiers:
            _dict['routing_identifiers'] = self.routing_identifiers.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vendor_data
        if self.vendor_data:
            _dict['vendor_data'] = self.vendor_data.to_dict()
        # override the default output from pydantic by calling `to_dict()` of vendor_info
        if self.vendor_info:
            _dict['vendor_info'] = self.vendor_info.to_dict()
        # override the default output from pydantic by calling `to_dict()` of verification
        if self.verification:
            _dict['verification'] = self.verification.to_dict()
        # set to None if nickname (nullable) is None
        if self.nickname is None:
            _dict['nickname'] = None

        # set to None if verification (nullable) is None
        if self.verification is None:
            _dict['verification'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ExternalAccount:
        """Create an instance of ExternalAccount from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ExternalAccount.parse_obj(obj)

        _obj = ExternalAccount.parse_obj({
            "account_identifiers": AccountIdentifiers.from_dict(obj.get("account_identifiers")) if obj.get("account_identifiers") is not None else None,
            "account_owner_names": obj.get("account_owner_names"),
            "business_id": obj.get("business_id"),
            "creation_time": obj.get("creation_time"),
            "customer_id": obj.get("customer_id"),
            "deletion_time": obj.get("deletion_time"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "nickname": obj.get("nickname"),
            "routing_identifiers": AccountRouting.from_dict(obj.get("routing_identifiers")) if obj.get("routing_identifiers") is not None else None,
            "status": obj.get("status"),
            "type": obj.get("type"),
            "vendor_data": ExternalAccountVendorData.from_dict(obj.get("vendor_data")) if obj.get("vendor_data") is not None else None,
            "vendor_info": VendorInfo.from_dict(obj.get("vendor_info")) if obj.get("vendor_info") is not None else None,
            "verification": AccountVerification.from_dict(obj.get("verification")) if obj.get("verification") is not None else None
        })
        return _obj

