# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr, constr, validator

class EvaluationContextCustomer(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    bank_id: StrictInt = Field(..., description="bank ID of the customer being evaluated")
    email: Optional[StrictStr] = Field(None, description="Evaluate rules matching this email address. ")
    partner_id: StrictInt = Field(..., description="partner ID of the customer being evaluated")
    phone_number: Optional[constr(strict=True)] = Field(None, description="Evaluate rules matching this phone number. Use E.164 format, with a leading \"+\" and a country code. ")
    resource_type: StrictStr = ...
    ssn_token: Optional[StrictStr] = Field(None, description="Evaluate rules matching for the SSN represented by this token. ")
    __properties = ["bank_id", "email", "partner_id", "phone_number", "resource_type", "ssn_token"]

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EvaluationContextCustomer:
        """Create an instance of EvaluationContextCustomer from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EvaluationContextCustomer:
        """Create an instance of EvaluationContextCustomer from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EvaluationContextCustomer.parse_obj(obj)

        _obj = EvaluationContextCustomer.parse_obj({
            "bank_id": obj.get("bank_id"),
            "email": obj.get("email"),
            "partner_id": obj.get("partner_id"),
            "phone_number": obj.get("phone_number"),
            "resource_type": obj.get("resource_type"),
            "ssn_token": obj.get("ssn_token")
        })
        return _obj

