# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictFloat, StrictInt, StrictStr

class EnhancedTransactionDataEnhancedRawInner(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: Optional[StrictFloat] = Field(None, description="The monetary amount of the transaction")
    categorized_by: Optional[StrictInt] = Field(None, description="The method used to detrmine the category")
    category: Optional[StrictStr] = Field(None, description="The category of the transaction")
    category_guid: Optional[StrictStr] = Field(None, description="The unique identifier for the category")
    described_by: Optional[StrictInt] = Field(None, description="The method used to describe the transaction")
    description: Optional[StrictStr] = Field(None, description="A human-readable version of `original_description`")
    extended_transaction_type: Optional[StrictStr] = Field(None, description="The transaction type assigned by the partner")
    id: Optional[StrictInt] = Field(None, description="The unique partner-defined identifier for the transaction")
    is_bill_pay: Optional[StrictBool] = Field(None, description="Whether the transaction represents a bill payment")
    is_direct_deposit: Optional[StrictBool] = Field(None, description="Whether or not the transaction represents a direct deposit")
    is_expense: Optional[StrictBool] = Field(None, description="Whether or not the transaction represents an expense")
    is_fee: Optional[StrictBool] = Field(None, description="Whether or not the transaction represents a fee")
    is_income: Optional[StrictBool] = Field(None, description="Whether or not the transaction represents income")
    is_international: Optional[StrictBool] = Field(None, description="Whether or not the transaction is international")
    is_overdraft_fee: Optional[StrictBool] = Field(None, description="Whether or not the transaction is an overdraft fee")
    is_payroll_advance: Optional[StrictBool] = Field(None, description="Whether or not the transaction is a payroll advance")
    is_subscription: Optional[StrictBool] = Field(None, description="Whether or not the transaction is a subscription")
    memo: Optional[StrictStr] = Field(None, description="Additional descriptiive information about the transaction")
    merchant_category_code: Optional[StrictInt] = Field(None, description="The ISO 18245 category code for the transaction")
    merchant_guid: Optional[StrictStr] = Field(None, description="The unique identifier for the merchant")
    merchant_location_guid: Optional[StrictStr] = Field(None, description="The unique identifier for the merchant location")
    original_description: Optional[StrictStr] = Field(None, description="The original description for the transaction")
    type: Optional[StrictStr] = Field(None, description="The type of the transsaction. This will be either `CREDIT` or `DEBIT`")
    __properties = ["amount", "categorized_by", "category", "category_guid", "described_by", "description", "extended_transaction_type", "id", "is_bill_pay", "is_direct_deposit", "is_expense", "is_fee", "is_income", "is_international", "is_overdraft_fee", "is_payroll_advance", "is_subscription", "memo", "merchant_category_code", "merchant_guid", "merchant_location_guid", "original_description", "type"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> EnhancedTransactionDataEnhancedRawInner:
        """Create an instance of EnhancedTransactionDataEnhancedRawInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> EnhancedTransactionDataEnhancedRawInner:
        """Create an instance of EnhancedTransactionDataEnhancedRawInner from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return EnhancedTransactionDataEnhancedRawInner.parse_obj(obj)

        _obj = EnhancedTransactionDataEnhancedRawInner.parse_obj({
            "amount": obj.get("amount"),
            "categorized_by": obj.get("categorized_by"),
            "category": obj.get("category"),
            "category_guid": obj.get("category_guid"),
            "described_by": obj.get("described_by"),
            "description": obj.get("description"),
            "extended_transaction_type": obj.get("extended_transaction_type"),
            "id": obj.get("id"),
            "is_bill_pay": obj.get("is_bill_pay"),
            "is_direct_deposit": obj.get("is_direct_deposit"),
            "is_expense": obj.get("is_expense"),
            "is_fee": obj.get("is_fee"),
            "is_income": obj.get("is_income"),
            "is_international": obj.get("is_international"),
            "is_overdraft_fee": obj.get("is_overdraft_fee"),
            "is_payroll_advance": obj.get("is_payroll_advance"),
            "is_subscription": obj.get("is_subscription"),
            "memo": obj.get("memo"),
            "merchant_category_code": obj.get("merchant_category_code"),
            "merchant_guid": obj.get("merchant_guid"),
            "merchant_location_guid": obj.get("merchant_location_guid"),
            "original_description": obj.get("original_description"),
            "type": obj.get("type")
        })
        return _obj

