# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from synctera_client.models.document_type import DocumentType
from synctera_client.models.encryption import Encryption
from synctera_client.models.related_resource_type import RelatedResourceType

class Document(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    available_versions: Optional[List[StrictInt]] = Field(None, description="All document versions")
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created")
    description: Optional[StrictStr] = Field(None, description="A description of the document")
    encryption: Optional[Encryption] = None
    file_name: Optional[StrictStr] = Field(None, description="The name of the document")
    id: Optional[StrictStr] = Field(None, description="The unique identifier for this resource")
    is_restricted: Optional[StrictBool] = Field(None, description="whether this document should be restricted (special permissions will be used to access restricted documents)")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated")
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    name: Optional[StrictStr] = Field(None, description="A user-friendly name for the document")
    related_resource_id: Optional[StrictStr] = Field(None, description="The ID of the resource related to the document")
    related_resource_type: Optional[RelatedResourceType] = None
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    type: Optional[DocumentType] = None
    version: Optional[StrictInt] = Field(None, description="The document version")
    __properties = ["available_versions", "creation_time", "description", "encryption", "file_name", "id", "is_restricted", "last_updated_time", "metadata", "name", "related_resource_id", "related_resource_type", "tenant", "type", "version"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Document:
        """Create an instance of Document from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "file_name",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Document:
        """Create an instance of Document from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Document.parse_obj(obj)

        _obj = Document.parse_obj({
            "available_versions": obj.get("available_versions"),
            "creation_time": obj.get("creation_time"),
            "description": obj.get("description"),
            "encryption": obj.get("encryption"),
            "file_name": obj.get("file_name"),
            "id": obj.get("id"),
            "is_restricted": obj.get("is_restricted"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "name": obj.get("name"),
            "related_resource_id": obj.get("related_resource_id"),
            "related_resource_type": obj.get("related_resource_type"),
            "tenant": obj.get("tenant"),
            "type": obj.get("type"),
            "version": obj.get("version")
        })
        return _obj

