# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, validator

class Disclosure1(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    creation_time: Optional[datetime] = None
    event_type: StrictStr = ...
    id: Optional[StrictStr] = Field(None, description="Disclosure ID")
    last_updated_time: Optional[datetime] = None
    timestamp: datetime = Field(..., description="Date of disclosure")
    type: StrictStr = Field(..., description="Disclosure Type")
    version: StrictStr = Field(..., description="Disclosure Version")
    __properties = ["creation_time", "event_type", "id", "last_updated_time", "timestamp", "type", "version"]

    @validator('event_type')
    def event_type_validate_enum(cls, v):
        if v not in ('DISPLAYED', 'VIEWED', 'ACKNOWLEDGED'):
            raise ValueError("must validate the enum values ('DISPLAYED', 'VIEWED', 'ACKNOWLEDGED')")
        return v

    @validator('type')
    def type_validate_enum(cls, v):
        if v not in ('ACH_AUTHORIZATION', 'CARDHOLDER_AGREEMENT', 'E_SIGN', 'KYC_DATA_COLLECTION', 'PRIVACY_NOTICE', 'REG_CC', 'REG_DD', 'REG_E', 'TERMS_AND_CONDITIONS'):
            raise ValueError("must validate the enum values ('ACH_AUTHORIZATION', 'CARDHOLDER_AGREEMENT', 'E_SIGN', 'KYC_DATA_COLLECTION', 'PRIVACY_NOTICE', 'REG_CC', 'REG_DD', 'REG_E', 'TERMS_AND_CONDITIONS')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Disclosure1:
        """Create an instance of Disclosure1 from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "last_updated_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Disclosure1:
        """Create an instance of Disclosure1 from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Disclosure1.parse_obj(obj)

        _obj = Disclosure1.parse_obj({
            "creation_time": obj.get("creation_time"),
            "event_type": obj.get("event_type"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "timestamp": obj.get("timestamp"),
            "type": obj.get("type"),
            "version": obj.get("version")
        })
        return _obj

