# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.digital_wallet_token_state import DigitalWalletTokenState

class DigitalWalletTokenResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    approved_time: Optional[datetime] = None
    card_id: Optional[StrictStr] = Field(None, description="Card ID of the Digital wallet Token")
    device_id: Optional[constr(strict=True, max_length=124)] = Field(None, description="The user’s Android device ID; the device’s unique identifier.")
    device_type: Optional[StrictStr] = Field(None, description="Type of the device where the Digital Wallet Token is used in")
    id: Optional[StrictStr] = Field(None, description="Digital Wallet Token ID")
    last_modified_time: Optional[datetime] = None
    requested_time: Optional[datetime] = None
    state: Optional[DigitalWalletTokenState] = None
    type: Optional[StrictStr] = Field(None, description="Type of the Digital Wallet")
    __properties = ["approved_time", "card_id", "device_id", "device_type", "id", "last_modified_time", "requested_time", "state", "type"]

    @validator('device_type')
    def device_type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('MOBILE_PHONE', 'WATCH', 'TABLET', 'MOBILE_PHONE_OR_TABLET', 'VEHICLE', 'APPLIANCE', 'LAPTOP', 'GAMING_DEVICE', 'UNKNOWN'):
            raise ValueError("must validate the enum values ('MOBILE_PHONE', 'WATCH', 'TABLET', 'MOBILE_PHONE_OR_TABLET', 'VEHICLE', 'APPLIANCE', 'LAPTOP', 'GAMING_DEVICE', 'UNKNOWN')")
        return v

    @validator('type')
    def type_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('APPLE_PAY', 'ANDROID_PAY', 'SAMSUNG_PAY'):
            raise ValueError("must validate the enum values ('APPLE_PAY', 'ANDROID_PAY', 'SAMSUNG_PAY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> DigitalWalletTokenResponse:
        """Create an instance of DigitalWalletTokenResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> DigitalWalletTokenResponse:
        """Create an instance of DigitalWalletTokenResponse from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return DigitalWalletTokenResponse.parse_obj(obj)

        _obj = DigitalWalletTokenResponse.parse_obj({
            "approved_time": obj.get("approved_time"),
            "card_id": obj.get("card_id"),
            "device_id": obj.get("device_id"),
            "device_type": obj.get("device_type"),
            "id": obj.get("id"),
            "last_modified_time": obj.get("last_modified_time"),
            "requested_time": obj.get("requested_time"),
            "state": obj.get("state"),
            "type": obj.get("type")
        })
        return _obj

