# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr

class CardTransactionDataPos(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    card_data_input_capability: Optional[StrictStr] = Field(None, description="Terminal Card data acceptance method")
    card_holder_presence: Optional[StrictBool] = Field(None, description="Cardholder presence")
    card_presence: Optional[StrictBool] = Field(None, description="Card presence")
    cardholder_authentication_method: Optional[StrictStr] = Field(None, description="Cardholder authentication method")
    country_code: Optional[StrictStr] = Field(None, description="Terminal country code")
    is_installment: Optional[StrictBool] = Field(None, description="Transaction is an installment payment")
    is_recurring: Optional[StrictBool] = Field(None, description="Transaction is recurring")
    pan_entry_mode: Optional[StrictStr] = Field(None, description="Card pan capture method")
    partial_approval_capable: Optional[StrictBool] = Field(None, description="Terminal partial approval capability")
    pin_entry_mode: Optional[StrictStr] = Field(None, description="Card pin capture method")
    pin_present: Optional[StrictBool] = Field(None, description="Pin presence")
    purchase_amount_only: Optional[StrictBool] = Field(None, description="Terminal purchase amount only")
    terminal_attendance: Optional[StrictStr] = Field(None, description="Terminal attendance")
    terminal_id: Optional[StrictStr] = Field(None, description="Terminal identifier")
    terminal_location: Optional[StrictStr] = Field(None, description="Terminal location")
    terminal_type: Optional[StrictStr] = Field(None, description="Terminal type")
    zip: Optional[StrictStr] = Field(None, description="Terminal zip code")
    __properties = ["card_data_input_capability", "card_holder_presence", "card_presence", "cardholder_authentication_method", "country_code", "is_installment", "is_recurring", "pan_entry_mode", "partial_approval_capable", "pin_entry_mode", "pin_present", "purchase_amount_only", "terminal_attendance", "terminal_id", "terminal_location", "terminal_type", "zip"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardTransactionDataPos:
        """Create an instance of CardTransactionDataPos from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardTransactionDataPos:
        """Create an instance of CardTransactionDataPos from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardTransactionDataPos.parse_obj(obj)

        _obj = CardTransactionDataPos.parse_obj({
            "card_data_input_capability": obj.get("card_data_input_capability"),
            "card_holder_presence": obj.get("card_holder_presence"),
            "card_presence": obj.get("card_presence"),
            "cardholder_authentication_method": obj.get("cardholder_authentication_method"),
            "country_code": obj.get("country_code"),
            "is_installment": obj.get("is_installment"),
            "is_recurring": obj.get("is_recurring"),
            "pan_entry_mode": obj.get("pan_entry_mode"),
            "partial_approval_capable": obj.get("partial_approval_capable"),
            "pin_entry_mode": obj.get("pin_entry_mode"),
            "pin_present": obj.get("pin_present"),
            "purchase_amount_only": obj.get("purchase_amount_only"),
            "terminal_attendance": obj.get("terminal_attendance"),
            "terminal_id": obj.get("terminal_id"),
            "terminal_location": obj.get("terminal_location"),
            "terminal_type": obj.get("terminal_type"),
            "zip": obj.get("zip")
        })
        return _obj

