# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr

class CardTransactionDataMerchant(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    address: Optional[StrictStr] = Field(None, description="Merchant address")
    city: Optional[StrictStr] = Field(None, description="Merchant city")
    country_code: Optional[StrictStr] = Field(None, description="Merchant country code")
    independent_sales_organization_id: Optional[StrictStr] = Field(None, description="Independent sales organization identifier")
    mcc: Optional[StrictStr] = Field(None, description="Merchant category code")
    mid: Optional[StrictStr] = Field(None, description="Merchant identifier")
    name: Optional[StrictStr] = Field(None, description="Merchant name")
    payment_facilitator_id: Optional[StrictStr] = Field(None, description="Payment facilitator identifier")
    postal_code: Optional[StrictStr] = Field(None, description="Merchant postal code")
    state: Optional[StrictStr] = Field(None, description="Merchant state")
    sub_merchant_id: Optional[StrictStr] = Field(None, description="Sub merchant identifier")
    __properties = ["address", "city", "country_code", "independent_sales_organization_id", "mcc", "mid", "name", "payment_facilitator_id", "postal_code", "state", "sub_merchant_id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardTransactionDataMerchant:
        """Create an instance of CardTransactionDataMerchant from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardTransactionDataMerchant:
        """Create an instance of CardTransactionDataMerchant from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardTransactionDataMerchant.parse_obj(obj)

        _obj = CardTransactionDataMerchant.parse_obj({
            "address": obj.get("address"),
            "city": obj.get("city"),
            "country_code": obj.get("country_code"),
            "independent_sales_organization_id": obj.get("independent_sales_organization_id"),
            "mcc": obj.get("mcc"),
            "mid": obj.get("mid"),
            "name": obj.get("name"),
            "payment_facilitator_id": obj.get("payment_facilitator_id"),
            "postal_code": obj.get("postal_code"),
            "state": obj.get("state"),
            "sub_merchant_id": obj.get("sub_merchant_id")
        })
        return _obj

