# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.card_transaction_data_currency_conversion import CardTransactionDataCurrencyConversion
from synctera_client.models.card_transaction_data_merchant import CardTransactionDataMerchant
from synctera_client.models.card_transaction_data_pos import CardTransactionDataPos

class CardTransactionData(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    card_id: Optional[StrictStr] = Field(None, description="Debit Network ID")
    currency_code: Optional[StrictStr] = None
    currency_conversion: Optional[CardTransactionDataCurrencyConversion] = None
    merchant: Optional[CardTransactionDataMerchant] = None
    network: Optional[StrictStr] = Field(None, description="The network used for the transaction")
    network_reference_id: Optional[StrictStr] = Field(None, description="The ID provided by he network to represent this transaction")
    pos: Optional[CardTransactionDataPos] = None
    __properties = ["card_id", "currency_code", "currency_conversion", "merchant", "network", "network_reference_id", "pos"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardTransactionData:
        """Create an instance of CardTransactionData from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "card_id",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of currency_conversion
        if self.currency_conversion:
            _dict['currency_conversion'] = self.currency_conversion.to_dict()
        # override the default output from pydantic by calling `to_dict()` of merchant
        if self.merchant:
            _dict['merchant'] = self.merchant.to_dict()
        # override the default output from pydantic by calling `to_dict()` of pos
        if self.pos:
            _dict['pos'] = self.pos.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardTransactionData:
        """Create an instance of CardTransactionData from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardTransactionData.parse_obj(obj)

        _obj = CardTransactionData.parse_obj({
            "card_id": obj.get("card_id"),
            "currency_code": obj.get("currency_code"),
            "currency_conversion": CardTransactionDataCurrencyConversion.from_dict(obj.get("currency_conversion")) if obj.get("currency_conversion") is not None else None,
            "merchant": CardTransactionDataMerchant.from_dict(obj.get("merchant")) if obj.get("merchant") is not None else None,
            "network": obj.get("network"),
            "network_reference_id": obj.get("network_reference_id"),
            "pos": CardTransactionDataPos.from_dict(obj.get("pos")) if obj.get("pos") is not None else None
        })
        return _obj

