# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.card_brand import CardBrand
from synctera_client.models.card_category import CardCategory
from synctera_client.models.card_product_type import CardProductType

class CardProgramUpdateRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    card_brand: Optional[CardBrand] = None
    card_category: Optional[CardCategory] = None
    card_product_type: Optional[CardProductType] = None
    end_date: Optional[datetime] = Field(None, description="The time when program became inactive")
    name: Optional[StrictStr] = Field(None, description="Program name")
    start_date: Optional[datetime] = Field(None, description="The time when program becomes active")
    __properties = ["card_brand", "card_category", "card_product_type", "end_date", "name", "start_date"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardProgramUpdateRequest:
        """Create an instance of CardProgramUpdateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardProgramUpdateRequest:
        """Create an instance of CardProgramUpdateRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardProgramUpdateRequest.parse_obj(obj)

        _obj = CardProgramUpdateRequest.parse_obj({
            "card_brand": obj.get("card_brand"),
            "card_category": obj.get("card_category"),
            "card_product_type": obj.get("card_product_type"),
            "end_date": obj.get("end_date"),
            "name": obj.get("name"),
            "start_date": obj.get("start_date")
        })
        return _obj

