# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr
from synctera_client.models.card_brand import CardBrand
from synctera_client.models.card_category import CardCategory
from synctera_client.models.card_product_type import CardProductType

class CardProgram(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    active: Optional[StrictBool] = Field(None, description="indicates whether program is active")
    bank_id: StrictInt = Field(..., description="The ID of the bank partner works with within this program")
    card_brand: CardBrand = ...
    card_category: CardCategory = ...
    card_product_type: CardProductType = ...
    creation_time: Optional[datetime] = Field(None, description="The timestamp representing when the program was created")
    end_date: Optional[datetime] = Field(None, description="The time when program became inactive")
    id: Optional[StrictStr] = Field(None, description="Program ID")
    last_modified_time: Optional[datetime] = Field(None, description="The timestamp representing when the program was last modified")
    name: StrictStr = Field(..., description="Program name")
    partner_id: StrictInt = Field(..., description="The ID of the partner program belongs to")
    start_date: Optional[datetime] = Field(None, description="The time when program becomes active")
    __properties = ["active", "bank_id", "card_brand", "card_category", "card_product_type", "creation_time", "end_date", "id", "last_modified_time", "name", "partner_id", "start_date"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardProgram:
        """Create an instance of CardProgram from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_modified_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardProgram:
        """Create an instance of CardProgram from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardProgram.parse_obj(obj)

        _obj = CardProgram.parse_obj({
            "active": obj.get("active"),
            "bank_id": obj.get("bank_id"),
            "card_brand": obj.get("card_brand"),
            "card_category": obj.get("card_category"),
            "card_product_type": obj.get("card_product_type"),
            "creation_time": obj.get("creation_time"),
            "end_date": obj.get("end_date"),
            "id": obj.get("id"),
            "last_modified_time": obj.get("last_modified_time"),
            "name": obj.get("name"),
            "partner_id": obj.get("partner_id"),
            "start_date": obj.get("start_date")
        })
        return _obj

