# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator
from synctera_client.models.card_image_mode import CardImageMode
from synctera_client.models.digital_wallet_tokenization import DigitalWalletTokenization
from synctera_client.models.physical_card_format import PhysicalCardFormat
from synctera_client.models.shipping import Shipping
from synctera_client.models.txn_enhancer import TxnEnhancer

class CardProductInternal(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    form: StrictStr = Field(..., description="PHYSICAL or VIRTUAL.")
    active: StrictBool = Field(..., description="Indicates whether the Card Product is active")
    card_program_id: StrictStr = Field(..., description="Card Program ID")
    color: Optional[constr(strict=True)] = Field(None, description="Color code for dynamic card elements such as PAN and card holder name")
    creation_time: Optional[datetime] = Field(None, description="The timestamp representing when the Card Product was created")
    digital_wallet_tokenization: Optional[DigitalWalletTokenization] = None
    end_date: Optional[datetime] = Field(None, description="The time when the Card Product is decommissioned")
    id: Optional[StrictStr] = Field(None, description="Card Product ID")
    image: Optional[StrictBool] = Field(None, description="Indicates whether or not there is an overlay image of the card product available")
    image_mode: Optional[CardImageMode] = None
    issue_without_kyc: Optional[StrictBool] = Field(None, description="Allow issuing cards on this product without requiring KYC")
    last_modified_time: Optional[datetime] = Field(None, description="The timestamp representing when the Card Product was last modified")
    name: constr(strict=True, max_length=40, min_length=1) = Field(..., description="The name of the Card Product")
    orientation: Optional[StrictStr] = Field(None, description="Card orientation")
    package_id: Optional[constr(strict=True, max_length=50, min_length=1)] = Field(None, description="Card fulfillment provider’s package ID")
    physical_card_format: Optional[PhysicalCardFormat] = None
    return_address: Optional[Shipping] = None
    start_date: datetime = Field(..., description="The time when the Card Product goes live")
    txn_enhancer: Optional[TxnEnhancer] = None
    account_range_id: StrictStr = Field(..., description="Account Range ID")
    auto_allocate_range: StrictBool = Field(..., description="Identifies whether a new account range will be automatically allocated")
    bank_id: StrictInt = Field(..., description="Bank ID")
    bin_id: StrictStr = Field(..., description="BIN ID")
    funding_source_id: StrictStr = Field(..., description="Funding Source ID")
    partner_id: StrictInt = Field(..., description="Partner ID")
    __properties = ["form", "active", "card_program_id", "color", "creation_time", "digital_wallet_tokenization", "end_date", "id", "image", "image_mode", "issue_without_kyc", "last_modified_time", "name", "orientation", "package_id", "physical_card_format", "return_address", "start_date", "txn_enhancer", "account_range_id", "auto_allocate_range", "bank_id", "bin_id", "funding_source_id", "partner_id"]

    @validator('form')
    def form_validate_enum(cls, v):
        if v not in ('PHYSICAL', 'VIRTUAL'):
            raise ValueError("must validate the enum values ('PHYSICAL', 'VIRTUAL')")
        return v

    @validator('color')
    def color_validate_regular_expression(cls, v):
        if not re.match(r"^[0-9A-F]{6}$", v):
            raise ValueError(r"must validate the regular expression /^[0-9A-F]{6}$/")
        return v

    @validator('orientation')
    def orientation_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('HORIZONTAL', 'VERTICAL'):
            raise ValueError("must validate the enum values ('HORIZONTAL', 'VERTICAL')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardProductInternal:
        """Create an instance of CardProductInternal from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_modified_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of digital_wallet_tokenization
        if self.digital_wallet_tokenization:
            _dict['digital_wallet_tokenization'] = self.digital_wallet_tokenization.to_dict()
        # override the default output from pydantic by calling `to_dict()` of return_address
        if self.return_address:
            _dict['return_address'] = self.return_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardProductInternal:
        """Create an instance of CardProductInternal from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardProductInternal.parse_obj(obj)

        _obj = CardProductInternal.parse_obj({
            "form": obj.get("form"),
            "active": obj.get("active"),
            "card_program_id": obj.get("card_program_id"),
            "color": obj.get("color"),
            "creation_time": obj.get("creation_time"),
            "digital_wallet_tokenization": DigitalWalletTokenization.from_dict(obj.get("digital_wallet_tokenization")) if obj.get("digital_wallet_tokenization") is not None else None,
            "end_date": obj.get("end_date"),
            "id": obj.get("id"),
            "image": obj.get("image"),
            "image_mode": obj.get("image_mode"),
            "issue_without_kyc": obj.get("issue_without_kyc"),
            "last_modified_time": obj.get("last_modified_time"),
            "name": obj.get("name"),
            "orientation": obj.get("orientation"),
            "package_id": obj.get("package_id"),
            "physical_card_format": obj.get("physical_card_format"),
            "return_address": Shipping.from_dict(obj.get("return_address")) if obj.get("return_address") is not None else None,
            "start_date": obj.get("start_date"),
            "txn_enhancer": obj.get("txn_enhancer"),
            "account_range_id": obj.get("account_range_id"),
            "auto_allocate_range": obj.get("auto_allocate_range"),
            "bank_id": obj.get("bank_id"),
            "bin_id": obj.get("bin_id"),
            "funding_source_id": obj.get("funding_source_id"),
            "partner_id": obj.get("partner_id")
        })
        return _obj

