# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Dict, Optional
from pydantic import BaseModel, Field, StrictStr, constr
from synctera_client.models.card_status_reason_code import CardStatusReasonCode
from synctera_client.models.card_status_request import CardStatusRequest
from synctera_client.models.emboss_name import EmbossName

class CardEditRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    card_status: Optional[CardStatusRequest] = None
    customer_id: Optional[StrictStr] = Field(None, description="The ID of the customer to whom the card will be issued")
    emboss_name: Optional[EmbossName] = None
    memo: Optional[constr(strict=True, max_length=255)] = Field(None, description="Additional details about the reason for the status change")
    metadata: Optional[Dict[str, StrictStr]] = Field(None, description="Additional data to include in the request structured as key-value pairs")
    reason: Optional[CardStatusReasonCode] = None
    __properties = ["card_status", "customer_id", "emboss_name", "memo", "metadata", "reason"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardEditRequest:
        """Create an instance of CardEditRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of emboss_name
        if self.emboss_name:
            _dict['emboss_name'] = self.emboss_name.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardEditRequest:
        """Create an instance of CardEditRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardEditRequest.parse_obj(obj)

        _obj = CardEditRequest.parse_obj({
            "card_status": obj.get("card_status"),
            "customer_id": obj.get("customer_id"),
            "emboss_name": EmbossName.from_dict(obj.get("emboss_name")) if obj.get("emboss_name") is not None else None,
            "memo": obj.get("memo"),
            "metadata": obj.get("metadata"),
            "reason": obj.get("reason")
        })
        return _obj

