# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr
from synctera_client.models.card_change_state import CardChangeState
from synctera_client.models.card_status_reason_code import CardStatusReasonCode
from synctera_client.models.change_channel import ChangeChannel
from synctera_client.models.change_type import ChangeType

class CardChange(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    change_type: ChangeType = ...
    channel: ChangeChannel = ...
    id: StrictStr = Field(..., description="Unique token")
    memo: Optional[constr(strict=True, max_length=255)] = Field(None, description="Additional details about the reason for the status change")
    reason: Optional[CardStatusReasonCode] = None
    state: CardChangeState = ...
    updated_at: datetime = Field(..., description="Date of change")
    updated_by: StrictStr = Field(..., description="ID of user who initiated the change, if done via Synctera Admin System")
    __properties = ["change_type", "channel", "id", "memo", "reason", "state", "updated_at", "updated_by"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CardChange:
        """Create an instance of CardChange from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "id",
                            "updated_at",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of state
        if self.state:
            _dict['state'] = self.state.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CardChange:
        """Create an instance of CardChange from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return CardChange.parse_obj(obj)

        _obj = CardChange.parse_obj({
            "change_type": obj.get("change_type"),
            "channel": obj.get("channel"),
            "id": obj.get("id"),
            "memo": obj.get("memo"),
            "reason": obj.get("reason"),
            "state": CardChangeState.from_dict(obj.get("state")) if obj.get("state") is not None else None,
            "updated_at": obj.get("updated_at"),
            "updated_by": obj.get("updated_by")
        })
        return _obj

