# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.address import Address
from synctera_client.models.verification_status import VerificationStatus

class Business(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    creation_time: Optional[datetime] = Field(None, description="The date and time the resource was created.")
    ein: Optional[StrictStr] = Field(None, description="U.S. Employer Identification Number (EIN) for this business, in the format xx-xxxxxxx.")
    email: Optional[StrictStr] = Field(None, description="Business's email.")
    entity_name: Optional[StrictStr] = Field(None, description="Business's legal name.")
    formation_date: Optional[date] = Field(None, description="Date the business was legally registered in RFC 3339 full-date format (YYYY-MM-DD).")
    formation_state: Optional[StrictStr] = Field(None, description="U.S. state where the business is legally registered (2-letter abbreviation).")
    id: Optional[StrictStr] = Field(None, description="Business's unique identifier.")
    is_customer: StrictBool = Field(..., description="True for personal and business customers with a direct relationship with the fintech or bank. Set this to true for any customer related to an account. ")
    last_updated_time: Optional[datetime] = Field(None, description="The date and time the resource was last updated.")
    legal_address: Optional[Address] = None
    metadata: Optional[Dict[str, Any]] = Field(None, description="Optional field to store additional information about the resource. Intended to be used by the integrator to store non-sensitive data. ")
    phone_number: Optional[constr(strict=True)] = Field(None, description="Business's phone number with country code in E.164 format. Must have a valid country code. Area code and local phone number are not validated.")
    status: StrictStr = Field(..., description="Status of the business. One of the following: * `PROSPECT` – a potential customer, used for information-gathering and disclosures. * `ACTIVE` –  is an integrator defined status.  Integrators should set a business to active if they believe the person to be qualified for conducting business.  Synctera will combine this status with other statuses such a verification to determine if the business is eligible for specific actions such as initiating transactions or issuing a card. * `FROZEN` – business's actions are blocked for security, legal, or other reasons. * `SANCTION` – business is on a sanctions list and should be carefully monitored. * `DISSOLVED` – an inactive status indicating a business entity has filed articles of dissolution or a certificate of termination to terminate its existence. * `CANCELLED` – an inactive status indicating that a business entity has filed a cancellation or has failed to file its periodic report after notice of forfeiture of its rights to do business. * `SUSPENDED` – an inactive status indicating that the business entity has lost the right to operate in it's registered jurisdiction. * `MERGED` – an inactive status indicating that the business entity has terminated existence by merging into another entity. * `INACTIVE` – an inactive status indicating that the business entity is no longer active. * `CONVERTED` – An inactive status indicating that the business entity has been converted to another type of business entity in the same jurisdiction. ")
    structure: Optional[StrictStr] = Field(None, description="Business's legal structure.")
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    trade_names: Optional[List[StrictStr]] = Field(None, description="Other names by which this business is known.")
    verification_last_run: Optional[datetime] = Field(None, description="Date and time KYB verification was last run on the business.")
    verification_status: Optional[VerificationStatus] = None
    website: Optional[StrictStr] = Field(None, description="Business's website.")
    __properties = ["creation_time", "ein", "email", "entity_name", "formation_date", "formation_state", "id", "is_customer", "last_updated_time", "legal_address", "metadata", "phone_number", "status", "structure", "tenant", "trade_names", "verification_last_run", "verification_status", "website"]

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    @validator('status')
    def status_validate_enum(cls, v):
        if v not in ('PROSPECT', 'ACTIVE', 'FROZEN', 'SANCTION', 'DISSOLVED', 'CANCELLED', 'SUSPENDED', 'MERGED', 'INACTIVE', 'CONVERTED'):
            raise ValueError("must validate the enum values ('PROSPECT', 'ACTIVE', 'FROZEN', 'SANCTION', 'DISSOLVED', 'CANCELLED', 'SUSPENDED', 'MERGED', 'INACTIVE', 'CONVERTED')")
        return v

    @validator('structure')
    def structure_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('SOLE_PROPRIETORSHIP', 'PARTNERSHIP', 'LLC', 'CORPORATION', 'S_CORPORATION', 'NON_PROFIT', 'OTHER'):
            raise ValueError("must validate the enum values ('SOLE_PROPRIETORSHIP', 'PARTNERSHIP', 'LLC', 'CORPORATION', 'S_CORPORATION', 'NON_PROFIT', 'OTHER')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Business:
        """Create an instance of Business from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                            "verification_last_run",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of legal_address
        if self.legal_address:
            _dict['legal_address'] = self.legal_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> Business:
        """Create an instance of Business from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return Business.parse_obj(obj)

        _obj = Business.parse_obj({
            "creation_time": obj.get("creation_time"),
            "ein": obj.get("ein"),
            "email": obj.get("email"),
            "entity_name": obj.get("entity_name"),
            "formation_date": obj.get("formation_date"),
            "formation_state": obj.get("formation_state"),
            "id": obj.get("id"),
            "is_customer": obj.get("is_customer"),
            "last_updated_time": obj.get("last_updated_time"),
            "legal_address": Address.from_dict(obj.get("legal_address")) if obj.get("legal_address") is not None else None,
            "metadata": obj.get("metadata"),
            "phone_number": obj.get("phone_number"),
            "status": obj.get("status"),
            "structure": obj.get("structure"),
            "tenant": obj.get("tenant"),
            "trade_names": obj.get("trade_names"),
            "verification_last_run": obj.get("verification_last_run"),
            "verification_status": obj.get("verification_status"),
            "website": obj.get("website")
        })
        return _obj

