# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Optional
from pydantic import BaseModel, Field, StrictStr, constr, validator
from synctera_client.models.ban_rule_status import BanRuleStatus
from synctera_client.models.resource_type import ResourceType

class BanRule(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    action: Optional[StrictStr] = Field(None, description="What action this rule performs")
    creation_time: Optional[datetime] = None
    email: Optional[StrictStr] = Field(None, description="This rule will match requests for customers with this email address. May contain a \"*\" as a wildcard. ")
    id: Optional[StrictStr] = Field(None, description="ban rule ID")
    last_updated_time: Optional[datetime] = None
    phone_number: Optional[constr(strict=True)] = Field(None, description="This rule will match requests for customers with this phone number. Use E.164 format, with a leading \"+\" and a country code. ")
    reason: Optional[StrictStr] = Field(None, description="The reason why the rule was added")
    resource_type: Optional[ResourceType] = None
    source: Optional[StrictStr] = Field(None, description="The source of the rule")
    ssn_hash: Optional[StrictStr] = Field(None, description="This rule will match requests for customers with an SSN that matches this value when hashed. ")
    status: Optional[BanRuleStatus] = None
    tenant: Optional[StrictStr] = Field(None, description="The tenant the rule applies to, with a format of \"b_p\" where \"b\" is the bank_id and \"p\" is the fintech partner_id. Bank requesters can specify a the fintech partner id as \"*\" to indicate the rule applies to all their fintechs. Synctera requesters can specify \"*_*\" to indicate the rule applies globally. The requester must have access to the specified tenant. If not supplied, the tenant defaults to the requester's tenant. ")
    __properties = ["action", "creation_time", "email", "id", "last_updated_time", "phone_number", "reason", "resource_type", "source", "ssn_hash", "status", "tenant"]

    @validator('action')
    def action_validate_enum(cls, v):
        if v is None:
            return v

        if v not in ('BAN'):
            raise ValueError("must validate the enum values ('BAN')")
        return v

    @validator('phone_number')
    def phone_number_validate_regular_expression(cls, v):
        if not re.match(r"^\+[1-9]\d{1,14}$", v):
            raise ValueError(r"must validate the regular expression /^\+[1-9]\d{1,14}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> BanRule:
        """Create an instance of BanRule from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "creation_time",
                            "id",
                            "last_updated_time",
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> BanRule:
        """Create an instance of BanRule from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return BanRule.parse_obj(obj)

        _obj = BanRule.parse_obj({
            "action": obj.get("action"),
            "creation_time": obj.get("creation_time"),
            "email": obj.get("email"),
            "id": obj.get("id"),
            "last_updated_time": obj.get("last_updated_time"),
            "phone_number": obj.get("phone_number"),
            "reason": obj.get("reason"),
            "resource_type": obj.get("resource_type"),
            "source": obj.get("source"),
            "ssn_hash": obj.get("ssn_hash"),
            "status": obj.get("status"),
            "tenant": obj.get("tenant")
        })
        return _obj

