# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictInt, StrictStr
from synctera_client.models.network_fee_model import NetworkFeeModel
from synctera_client.models.transaction_options import TransactionOptions

class AuthorizationAdviceModel(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: StrictInt = Field(..., description="The amount of the transaction in the smallest whole denomination of the applicable currency (eg. For USD use cents)")
    network_fees: Optional[List[NetworkFeeModel]] = None
    original_transaction_id: StrictStr = ...
    transaction_options: Optional[TransactionOptions] = None
    __properties = ["amount", "network_fees", "original_transaction_id", "transaction_options"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AuthorizationAdviceModel:
        """Create an instance of AuthorizationAdviceModel from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in network_fees (list)
        _items = []
        if self.network_fees:
            for _item in self.network_fees:
                if _item:
                    _items.append(_item.to_dict())
            _dict['network_fees'] = _items
        # override the default output from pydantic by calling `to_dict()` of transaction_options
        if self.transaction_options:
            _dict['transaction_options'] = self.transaction_options.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AuthorizationAdviceModel:
        """Create an instance of AuthorizationAdviceModel from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AuthorizationAdviceModel.parse_obj(obj)

        _obj = AuthorizationAdviceModel.parse_obj({
            "amount": obj.get("amount"),
            "network_fees": [NetworkFeeModel.from_dict(_item) for _item in obj.get("network_fees")] if obj.get("network_fees") is not None else None,
            "original_transaction_id": obj.get("original_transaction_id"),
            "transaction_options": TransactionOptions.from_dict(obj.get("transaction_options")) if obj.get("transaction_options") is not None else None
        })
        return _obj

