# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictBool, StrictInt, StrictStr, constr, validator
from synctera_client.models.address1 import Address1
from synctera_client.models.external_payment_date import ExternalPaymentDate

class ApplicationRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    bank_id: StrictInt = Field(..., description="Bank ID")
    business_address: Address1 = ...
    business_name: StrictStr = ...
    business_phone: StrictStr = ...
    business_tax_id: constr(strict=True, max_length=9, min_length=9) = ...
    business_type: StrictStr = ...
    dob: Optional[ExternalPaymentDate] = None
    doing_business_as: StrictStr = ...
    email: Optional[StrictStr] = None
    enabled: StrictBool = Field(..., description="To enable or disable aft/oct feature")
    first_name: Optional[StrictStr] = None
    incorporation_date: Optional[ExternalPaymentDate] = None
    last_name: Optional[StrictStr] = None
    max_transaction_amount: StrictInt = Field(..., description="Maximum amount that can be transacted for a single transaction in cents")
    partner_id: StrictInt = Field(..., description="Partner ID")
    personal_address: Optional[Address1] = None
    phone: Optional[StrictStr] = None
    principal_percentage_ownership: Optional[StrictStr] = None
    tax_id: Optional[constr(strict=True, max_length=9, min_length=9)] = None
    title: Optional[StrictStr] = None
    url: Optional[StrictStr] = None
    __properties = ["bank_id", "business_address", "business_name", "business_phone", "business_tax_id", "business_type", "dob", "doing_business_as", "email", "enabled", "first_name", "incorporation_date", "last_name", "max_transaction_amount", "partner_id", "personal_address", "phone", "principal_percentage_ownership", "tax_id", "title", "url"]

    @validator('business_type')
    def business_type_validate_enum(cls, v):
        if v not in ('INDIVIDUAL_SOLE_PROPRIETORSHIP', 'CORPORATION', 'LIMITED_LIABILITY_COMPANY', 'PARTNERSHIP', 'ASSOCIATION_ESTATE_TRUST', 'TAX_EXEMPT_ORGANIZATION', 'INTERNATIONAL_ORGANIZATION', 'GOVERNMENT_AGENCY'):
            raise ValueError("must validate the enum values ('INDIVIDUAL_SOLE_PROPRIETORSHIP', 'CORPORATION', 'LIMITED_LIABILITY_COMPANY', 'PARTNERSHIP', 'ASSOCIATION_ESTATE_TRUST', 'TAX_EXEMPT_ORGANIZATION', 'INTERNATIONAL_ORGANIZATION', 'GOVERNMENT_AGENCY')")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> ApplicationRequest:
        """Create an instance of ApplicationRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of business_address
        if self.business_address:
            _dict['business_address'] = self.business_address.to_dict()
        # override the default output from pydantic by calling `to_dict()` of dob
        if self.dob:
            _dict['dob'] = self.dob.to_dict()
        # override the default output from pydantic by calling `to_dict()` of incorporation_date
        if self.incorporation_date:
            _dict['incorporation_date'] = self.incorporation_date.to_dict()
        # override the default output from pydantic by calling `to_dict()` of personal_address
        if self.personal_address:
            _dict['personal_address'] = self.personal_address.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> ApplicationRequest:
        """Create an instance of ApplicationRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return ApplicationRequest.parse_obj(obj)

        _obj = ApplicationRequest.parse_obj({
            "bank_id": obj.get("bank_id"),
            "business_address": Address1.from_dict(obj.get("business_address")) if obj.get("business_address") is not None else None,
            "business_name": obj.get("business_name"),
            "business_phone": obj.get("business_phone"),
            "business_tax_id": obj.get("business_tax_id"),
            "business_type": obj.get("business_type"),
            "dob": ExternalPaymentDate.from_dict(obj.get("dob")) if obj.get("dob") is not None else None,
            "doing_business_as": obj.get("doing_business_as"),
            "email": obj.get("email"),
            "enabled": obj.get("enabled"),
            "first_name": obj.get("first_name"),
            "incorporation_date": ExternalPaymentDate.from_dict(obj.get("incorporation_date")) if obj.get("incorporation_date") is not None else None,
            "last_name": obj.get("last_name"),
            "max_transaction_amount": obj.get("max_transaction_amount"),
            "partner_id": obj.get("partner_id"),
            "personal_address": Address1.from_dict(obj.get("personal_address")) if obj.get("personal_address") is not None else None,
            "phone": obj.get("phone"),
            "principal_percentage_ownership": obj.get("principal_percentage_ownership"),
            "tax_id": obj.get("tax_id"),
            "title": obj.get("title"),
            "url": obj.get("url")
        })
        return _obj

