# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List
from pydantic import BaseModel, Field, StrictStr, constr
from synctera_client.models.device_type import DeviceType

class AppleDigitalWalletProvisionRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    certificates: List[StrictStr] = Field(..., description="Leaf and sub-CA certificates provided by Apple")
    device_type: DeviceType = ...
    nonce: StrictStr = Field(..., description="One-time-use nonce provided by Apple for security purposes.")
    nonce_signature: StrictStr = Field(..., description="Apple-provided signature to the nonce.")
    provisioning_app_version: constr(strict=True, max_length=50) = Field(..., description="Version of the application making the provisioning request.")
    __properties = ["certificates", "device_type", "nonce", "nonce_signature", "provisioning_app_version"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AppleDigitalWalletProvisionRequest:
        """Create an instance of AppleDigitalWalletProvisionRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AppleDigitalWalletProvisionRequest:
        """Create an instance of AppleDigitalWalletProvisionRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AppleDigitalWalletProvisionRequest.parse_obj(obj)

        _obj = AppleDigitalWalletProvisionRequest.parse_obj({
            "certificates": obj.get("certificates"),
            "device_type": obj.get("device_type"),
            "nonce": obj.get("nonce"),
            "nonce_signature": obj.get("nonce_signature"),
            "provisioning_app_version": obj.get("provisioning_app_version")
        })
        return _obj

