# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr
from synctera_client.models.ext_account_customer_type import ExtAccountCustomerType
from synctera_client.models.external_account_vendor_values import ExternalAccountVendorValues

class AddVendorAccountsRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    business_id: Optional[StrictStr] = Field(None, description="The identifier for the business customer associated with this external account. Exactly one of `business_id` or `customer_id` must be specified. ")
    customer_id: Optional[StrictStr] = Field(None, description="The identifier for the personal customer associated with this external account. Exactly one of `customer_id` or `business_id` must be specified. ")
    customer_type: ExtAccountCustomerType = ...
    vendor: ExternalAccountVendorValues = ...
    vendor_access_token: Optional[constr(strict=True, min_length=1)] = Field(None, description="The token provided to link external accounts. For Plaid, this is their `access_token`. ")
    vendor_account_ids: Optional[List[constr(strict=True, min_length=1)]] = Field(None, description="The list of vendor account IDs that the customer chose to link. For Plaid, these are `account_id`s. ")
    vendor_customer_id: Optional[StrictStr] = Field(None, description="The identifier provided by the vendor for the customer associated with this external account. ")
    verify_owner: Optional[StrictBool] = Field(False, description="If true, Synctera will attempt to verify that the external account owner is the same as the customer by comparing external account data to customer data. At least 2 of the following fields must match: name, phone number, email, address. Verification is disabled by default. ")
    __properties = ["business_id", "customer_id", "customer_type", "vendor", "vendor_access_token", "vendor_account_ids", "vendor_customer_id", "verify_owner"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddVendorAccountsRequest:
        """Create an instance of AddVendorAccountsRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AddVendorAccountsRequest:
        """Create an instance of AddVendorAccountsRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddVendorAccountsRequest.parse_obj(obj)

        _obj = AddVendorAccountsRequest.parse_obj({
            "business_id": obj.get("business_id"),
            "customer_id": obj.get("customer_id"),
            "customer_type": obj.get("customer_type"),
            "vendor": obj.get("vendor"),
            "vendor_access_token": obj.get("vendor_access_token"),
            "vendor_account_ids": obj.get("vendor_account_ids"),
            "vendor_customer_id": obj.get("vendor_customer_id"),
            "verify_owner": obj.get("verify_owner") if obj.get("verify_owner") is not None else False
        })
        return _obj

