# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, StrictStr
from synctera_client.models.add_vendor_accounts_error_reason import AddVendorAccountsErrorReason

class AddVendorAccountFailure(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    reason: AddVendorAccountsErrorReason = ...
    reason_description: StrictStr = Field(..., description="A human-readable message describing the reason for the failure.")
    vendor_account_id: StrictStr = Field(..., description="The vendor account ID for the account that failed. For Plaid, this is an `account_id`. ")
    vendor_error_message: Optional[StrictStr] = Field(None, description="The display_message returned by the vendor. Only returned if reason is set to `PROVIDER_ERROR`. For Plaid, this is the `display_message`. ")
    vendor_request_id: Optional[StrictStr] = Field(None, description="A unique identifier for the request from the vendor, which can be used for troubleshooting. Only returned if reason is set to `PROVIDER_ERROR`. ")
    __properties = ["reason", "reason_description", "vendor_account_id", "vendor_error_message", "vendor_request_id"]

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AddVendorAccountFailure:
        """Create an instance of AddVendorAccountFailure from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AddVendorAccountFailure:
        """Create an instance of AddVendorAccountFailure from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AddVendorAccountFailure.parse_obj(obj)

        _obj = AddVendorAccountFailure.parse_obj({
            "reason": obj.get("reason"),
            "reason_description": obj.get("reason_description"),
            "vendor_account_id": obj.get("vendor_account_id"),
            "vendor_error_message": obj.get("vendor_error_message"),
            "vendor_request_id": obj.get("vendor_request_id")
        })
        return _obj

