# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import date, datetime
from typing import Any, Dict, Optional
from pydantic import BaseModel, Field, StrictStr, conint

class AccountToAccountTransferRequest(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    amount: conint(strict=True, ge=0) = Field(..., description="The amount (in cents) to transfer from originating account to receiving account.")
    currency: StrictStr = Field(..., description="ISO 4217 alphabetic currency code of the transfer amount")
    description: Optional[StrictStr] = Field(None, description="A description of the transaction")
    dest_account_alias: Optional[StrictStr] = Field(None, description="An alias representing a GL account to credit. This is an alternative to specifying by account id")
    dest_account_id: Optional[StrictStr] = Field(None, description="The account id of the account being credited")
    dest_account_no: Optional[StrictStr] = Field(None, description="The account number of the account being credited")
    effective_date: Optional[datetime] = Field(None, description="The date the transaction should be effective")
    external_data: Optional[Dict[str, Any]] = Field(None, description="an unstructured json blob representing additional transaction information supplied by the integrator.")
    memo: Optional[StrictStr] = Field(None, description="A short note to the recipient")
    offset_description: Optional[StrictStr] = Field(None, description="A description of the offsetting transaction")
    posted_date: Optional[date] = Field(None, description="The date the transaction was posted")
    source_account_alias: Optional[StrictStr] = Field(None, description="An alias representing a GL account to debit. This is alternative to specifying by account id")
    source_account_id: Optional[StrictStr] = Field(None, description="The uuid of the the account being debited")
    source_account_no: Optional[StrictStr] = Field(None, description="The account number of the account being debited")
    subtype: Optional[StrictStr] = Field(None, description="The desired transaction subtype to use for this transfer")
    type: Optional[StrictStr] = Field(None, description="The desired transaction type to use for this transfer")
    user_data: Optional[Dict[str, Any]] = Field(None, description="An unstructured JSON blob representing additional transaction information specific to each payment rail.")
    uuid: Optional[StrictStr] = Field(None, description="The UUID of the transaction")
    __properties = ["amount", "currency", "description", "dest_account_alias", "dest_account_id", "dest_account_no", "effective_date", "external_data", "memo", "offset_description", "posted_date", "source_account_alias", "source_account_id", "source_account_no", "subtype", "type", "user_data", "uuid"]

    @validator('posted_date')
    def posted_date_validate_regular_expression(cls, v):
        if not re.match(r"([0-9]{4})-(?:[0-9]{2})-([0-9]{2})", v):
            raise ValueError(r"must validate the regular expression /([0-9]{4})-(?:[0-9]{2})-([0-9]{2})/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountToAccountTransferRequest:
        """Create an instance of AccountToAccountTransferRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        # set to None if external_data (nullable) is None
        if self.external_data is None:
            _dict['external_data'] = None

        # set to None if user_data (nullable) is None
        if self.user_data is None:
            _dict['user_data'] = None

        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountToAccountTransferRequest:
        """Create an instance of AccountToAccountTransferRequest from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountToAccountTransferRequest.parse_obj(obj)

        _obj = AccountToAccountTransferRequest.parse_obj({
            "amount": obj.get("amount"),
            "currency": obj.get("currency"),
            "description": obj.get("description"),
            "dest_account_alias": obj.get("dest_account_alias"),
            "dest_account_id": obj.get("dest_account_id"),
            "dest_account_no": obj.get("dest_account_no"),
            "effective_date": obj.get("effective_date"),
            "external_data": obj.get("external_data"),
            "memo": obj.get("memo"),
            "offset_description": obj.get("offset_description"),
            "posted_date": obj.get("posted_date"),
            "source_account_alias": obj.get("source_account_alias"),
            "source_account_id": obj.get("source_account_id"),
            "source_account_no": obj.get("source_account_no"),
            "subtype": obj.get("subtype"),
            "type": obj.get("type"),
            "user_data": obj.get("user_data"),
            "uuid": obj.get("uuid")
        })
        return _obj

