# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from typing import Any, Dict, List, Optional
from pydantic import BaseModel, Field, StrictBool, StrictStr, constr, validator
from synctera_client.models.account_access_status import AccountAccessStatus
from synctera_client.models.account_type import AccountType
from synctera_client.models.balance import Balance
from synctera_client.models.customer_type import CustomerType
from synctera_client.models.status import Status

class AccountBase(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    access_status: Optional[AccountAccessStatus] = None
    account_number: Optional[constr(strict=True, max_length=50)] = Field(None, description="Account number")
    account_number_masked: Optional[constr(strict=True, max_length=50)] = Field(None, description="The response will contain the bank fintech ID (3 or 6 digits) plus the last 4 digits, with the digits in between replaced with * characters. Shadow mode account numbers will not be masked.")
    account_purpose: Optional[StrictStr] = Field(None, description="Purpose of the account")
    account_type: Optional[AccountType] = None
    application_id: Optional[StrictStr] = Field(None, description="The application ID for this account. ")
    balances: Optional[List[Balance]] = Field(None, description="A list of balances for account based on different type")
    bank_routing: Optional[constr(strict=True, max_length=9)] = Field(None, description="Bank routing number")
    creation_time: Optional[datetime] = Field(None, description="Account creation timestamp in RFC3339 format")
    currency: Optional[constr(strict=True)] = Field(None, description="Account currency or account settlement currency. ISO 4217 alphabetic currency code. Default USD")
    customer_ids: Optional[List[StrictStr]] = Field(None, description="A list of the customer IDs of the account holders.")
    customer_type: Optional[CustomerType] = None
    exchange_rate_type: Optional[constr(strict=True, max_length=10)] = Field(None, description="Exchange rate type")
    iban: Optional[constr(strict=True, max_length=34)] = Field(None, description="International bank account number")
    id: Optional[StrictStr] = Field(None, description="Account ID")
    is_account_pool: Optional[StrictBool] = Field(None, description="Account is investment (variable balance) account or a multi-balance account pool. Default false")
    is_ach_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether ACH transactions are enabled.")
    is_card_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether card transactions are enabled.")
    is_p2p_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether P2P transactions are enabled.")
    is_wire_enabled: Optional[StrictBool] = Field(None, description="A flag to indicate whether wire transactions are enabled.")
    last_updated_time: Optional[datetime] = Field(None, description="Timestamp of the last account modification in RFC3339 format")
    metadata: Optional[Dict[str, Any]] = Field(None, description="User provided account metadata")
    nickname: Optional[StrictStr] = Field(None, description="User provided account nickname")
    status: Optional[Status] = None
    swift_code: Optional[constr(strict=True, max_length=11, min_length=8)] = Field(None, description="SWIFT code")
    tenant: Optional[StrictStr] = Field(None, description="The id of the tenant containing the resource. ")
    __properties = ["access_status", "account_number", "account_number_masked", "account_purpose", "account_type", "application_id", "balances", "bank_routing", "creation_time", "currency", "customer_ids", "customer_type", "exchange_rate_type", "iban", "id", "is_account_pool", "is_ach_enabled", "is_card_enabled", "is_p2p_enabled", "is_wire_enabled", "last_updated_time", "metadata", "nickname", "status", "swift_code", "tenant"]

    @validator('currency')
    def currency_validate_regular_expression(cls, v):
        if not re.match(r"^[A-Z]{3}$", v):
            raise ValueError(r"must validate the regular expression /^[A-Z]{3}$/")
        return v

    class Config:
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> AccountBase:
        """Create an instance of AccountBase from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "account_number",
                            "account_number_masked",
                            "balances",
                            "bank_routing",
                            "creation_time",
                            "customer_ids",
                            "id",
                            "is_ach_enabled",
                            "is_card_enabled",
                            "is_p2p_enabled",
                            "is_wire_enabled",
                            "last_updated_time",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of each item in balances (list)
        _items = []
        if self.balances:
            for _item in self.balances:
                if _item:
                    _items.append(_item.to_dict())
            _dict['balances'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> AccountBase:
        """Create an instance of AccountBase from a dict"""
        if obj is None:
            return None

        if type(obj) is not dict:
            return AccountBase.parse_obj(obj)

        _obj = AccountBase.parse_obj({
            "access_status": obj.get("access_status"),
            "account_number": obj.get("account_number"),
            "account_number_masked": obj.get("account_number_masked"),
            "account_purpose": obj.get("account_purpose"),
            "account_type": obj.get("account_type"),
            "application_id": obj.get("application_id"),
            "balances": [Balance.from_dict(_item) for _item in obj.get("balances")] if obj.get("balances") is not None else None,
            "bank_routing": obj.get("bank_routing"),
            "creation_time": obj.get("creation_time"),
            "currency": obj.get("currency"),
            "customer_ids": obj.get("customer_ids"),
            "customer_type": obj.get("customer_type"),
            "exchange_rate_type": obj.get("exchange_rate_type"),
            "iban": obj.get("iban"),
            "id": obj.get("id"),
            "is_account_pool": obj.get("is_account_pool"),
            "is_ach_enabled": obj.get("is_ach_enabled"),
            "is_card_enabled": obj.get("is_card_enabled"),
            "is_p2p_enabled": obj.get("is_p2p_enabled"),
            "is_wire_enabled": obj.get("is_wire_enabled"),
            "last_updated_time": obj.get("last_updated_time"),
            "metadata": obj.get("metadata"),
            "nickname": obj.get("nickname"),
            "status": obj.get("status"),
            "swift_code": obj.get("swift_code"),
            "tenant": obj.get("tenant")
        })
        return _obj

