# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import annotations
from inspect import getfullargspec
import pprint
import re  # noqa: F401

from typing import Optional
from pydantic import BaseModel, Field, StrictStr, ValidationError, validator
from synctera_client.models.account_charge_secured import AccountChargeSecured
from synctera_client.models.account_depository import AccountDepository
from synctera_client.models.account_line_of_credit import AccountLineOfCredit
from typing import Any, List
from pydantic import StrictStr, Field

ACCOUNT_ANY_OF_SCHEMAS = ["AccountChargeSecured", "AccountDepository", "AccountLineOfCredit"]

class Account(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """
    # data type: AccountDepository
    __anyof_schema_1: Optional[AccountDepository] = None
    # data type: AccountLineOfCredit
    __anyof_schema_2: Optional[AccountLineOfCredit] = None
    # data type: AccountChargeSecured
    __anyof_schema_3: Optional[AccountChargeSecured] = None
    actual_instance: Any
    any_of_schemas: List[str] = Field(ACCOUNT_ANY_OF_SCHEMAS, const=True)

    class Config:
        validate_assignment = True

    @validator('actual_instance')
    def actual_instance_must_validate_anyof(cls, v):
        error_messages = []
        # validate data type: AccountDepository
        if type(v) is not AccountDepository:
            error_messages.append(f"Error! Input type `{type(v)}` is not `AccountDepository`")
        else:
            return v

        # validate data type: AccountLineOfCredit
        if type(v) is not AccountLineOfCredit:
            error_messages.append(f"Error! Input type `{type(v)}` is not `AccountLineOfCredit`")
        else:
            return v

        # validate data type: AccountChargeSecured
        if type(v) is not AccountChargeSecured:
            error_messages.append(f"Error! Input type `{type(v)}` is not `AccountChargeSecured`")
        else:
            return v

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Account with anyOf schemas: AccountChargeSecured, AccountDepository, AccountLineOfCredit. Details: " + ", ".join(error_messages))
        else:
            return v

    @classmethod
    def from_json(cls, json_str: str) -> Account:
        """Returns the object represented by the json string"""
        instance = cls()
        error_messages = []
        # __anyof_schema_1: Optional[AccountDepository] = None
        try:
            instance.actual_instance = AccountDepository.from_json(json_str)
            return instance
        except ValidationError as e:
             error_messages.append(str(e))
        # __anyof_schema_2: Optional[AccountLineOfCredit] = None
        try:
            instance.actual_instance = AccountLineOfCredit.from_json(json_str)
            return instance
        except ValidationError as e:
             error_messages.append(str(e))
        # __anyof_schema_3: Optional[AccountChargeSecured] = None
        try:
            instance.actual_instance = AccountChargeSecured.from_json(json_str)
            return instance
        except ValidationError as e:
             error_messages.append(str(e))

        if error_messages:
            # no match
            raise ValueError("No match found when deserializing the JSON string into Account with anyOf schemas: AccountChargeSecured, AccountDepository, AccountLineOfCredit. Details: " + ", ".join(error_messages))
        else:
            return instance

    def to_json(self) -> str:
        """Returns the JSON representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_json()
        else:
            return "null"

    def to_dict(self) -> dict:
        """Returns the dict representation of the actual instance"""
        if self.actual_instance is not None:
            return self.actual_instance.to_dict()
        else:
            return dict()

    def to_str(self) -> str:
        """Returns the string representation of the actual instance"""
        return pprint.pformat(self.dict())

