# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint

from typing import Optional

from synctera_client.models.update_transfer import UpdateTransfer
from synctera_client.models.wire import Wire
from synctera_client.models.wire_list import WireList
from synctera_client.models.wire_request import WireRequest

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class WiresAlphaApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def cancel_wire(self, wire_id : Annotated[StrictStr, Field(..., description="The unique identifier of a wire")], update_transfer : Annotated[UpdateTransfer, Field(..., description="wire to update")], **kwargs) -> Wire:  # noqa: E501
        """Cancel an outgoing wire  # noqa: E501

        Cancel an outgoing tranfer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_wire(wire_id, update_transfer, async_req=True)
        >>> result = thread.get()

        :param wire_id: The unique identifier of a wire (required)
        :type wire_id: str
        :param update_transfer: wire to update (required)
        :type update_transfer: UpdateTransfer
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Wire
        """
        kwargs['_return_http_data_only'] = True
        return self.cancel_wire_with_http_info(wire_id, update_transfer, **kwargs)  # noqa: E501

    @validate_arguments
    def cancel_wire_with_http_info(self, wire_id : Annotated[StrictStr, Field(..., description="The unique identifier of a wire")], update_transfer : Annotated[UpdateTransfer, Field(..., description="wire to update")], **kwargs):  # noqa: E501
        """Cancel an outgoing wire  # noqa: E501

        Cancel an outgoing tranfer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.cancel_wire_with_http_info(wire_id, update_transfer, async_req=True)
        >>> result = thread.get()

        :param wire_id: The unique identifier of a wire (required)
        :type wire_id: str
        :param update_transfer: wire to update (required)
        :type update_transfer: UpdateTransfer
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Wire, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'wire_id',
            'update_transfer'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cancel_wire" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['wire_id']:
            _path_params['wire_id'] = _params['wire_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['update_transfer']:
            _body_params = _params['update_transfer']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Wire",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/wires/{wire_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_wire(self, wire_request : Annotated[WireRequest, Field(..., description="Wire transfer request")], **kwargs) -> Wire:  # noqa: E501
        """Send a wire  # noqa: E501

        Create an outgoing wire transfer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wire(wire_request, async_req=True)
        >>> result = thread.get()

        :param wire_request: Wire transfer request (required)
        :type wire_request: WireRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Wire
        """
        kwargs['_return_http_data_only'] = True
        return self.create_wire_with_http_info(wire_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_wire_with_http_info(self, wire_request : Annotated[WireRequest, Field(..., description="Wire transfer request")], **kwargs):  # noqa: E501
        """Send a wire  # noqa: E501

        Create an outgoing wire transfer  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_wire_with_http_info(wire_request, async_req=True)
        >>> result = thread.get()

        :param wire_request: Wire transfer request (required)
        :type wire_request: WireRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Wire, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'wire_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_wire" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['wire_request']:
            _body_params = _params['wire_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "Wire",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/wires', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_wire(self, wire_id : Annotated[StrictStr, Field(..., description="The unique identifier of a wire")], **kwargs) -> Wire:  # noqa: E501
        """Get a wire by id  # noqa: E501

        Get a wire by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wire(wire_id, async_req=True)
        >>> result = thread.get()

        :param wire_id: The unique identifier of a wire (required)
        :type wire_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: Wire
        """
        kwargs['_return_http_data_only'] = True
        return self.get_wire_with_http_info(wire_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_wire_with_http_info(self, wire_id : Annotated[StrictStr, Field(..., description="The unique identifier of a wire")], **kwargs):  # noqa: E501
        """Get a wire by id  # noqa: E501

        Get a wire by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_wire_with_http_info(wire_id, async_req=True)
        >>> result = thread.get()

        :param wire_id: The unique identifier of a wire (required)
        :type wire_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(Wire, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'wire_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_wire" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['wire_id']:
            _path_params['wire_id'] = _params['wire_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "Wire",
            '401': "Error",
            '403': "Error",
            '404': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/wires/{wire_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_wires(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, status : Optional[StrictStr] = None, customer_id : Optional[StrictStr] = None, originating_account_id : Optional[StrictStr] = None, receiving_account_id : Optional[StrictStr] = None, **kwargs) -> WireList:  # noqa: E501
        """List wires  # noqa: E501

        Get paginated list of wires  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_wires(limit, page_token, status, customer_id, originating_account_id, receiving_account_id, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param status:
        :type status: str
        :param customer_id:
        :type customer_id: str
        :param originating_account_id:
        :type originating_account_id: str
        :param receiving_account_id:
        :type receiving_account_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: WireList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_wires_with_http_info(limit, page_token, status, customer_id, originating_account_id, receiving_account_id, **kwargs)  # noqa: E501

    @validate_arguments
    def list_wires_with_http_info(self, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, status : Optional[StrictStr] = None, customer_id : Optional[StrictStr] = None, originating_account_id : Optional[StrictStr] = None, receiving_account_id : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List wires  # noqa: E501

        Get paginated list of wires  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_wires_with_http_info(limit, page_token, status, customer_id, originating_account_id, receiving_account_id, async_req=True)
        >>> result = thread.get()

        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param status:
        :type status: str
        :param customer_id:
        :type customer_id: str
        :param originating_account_id:
        :type originating_account_id: str
        :param receiving_account_id:
        :type receiving_account_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(WireList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'limit',
            'page_token',
            'status',
            'customer_id',
            'originating_account_id',
            'receiving_account_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_wires" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))
        if _params.get('status') is not None:  # noqa: E501
            _query_params.append(('status', _params['status']))
        if _params.get('customer_id') is not None:  # noqa: E501
            _query_params.append(('customer_id', _params['customer_id']))
        if _params.get('originating_account_id') is not None:  # noqa: E501
            _query_params.append(('originating_account_id', _params['originating_account_id']))
        if _params.get('receiving_account_id') is not None:  # noqa: E501
            _query_params.append(('receiving_account_id', _params['receiving_account_id']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "WireList",
            '401': "Error",
            '403': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/wires', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
