# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictBool, StrictStr, conint, validator

from typing import List, Optional

from synctera_client.models.payment_type import PaymentType
from synctera_client.models.spend_control import SpendControl
from synctera_client.models.spend_control_direction import SpendControlDirection
from synctera_client.models.spend_control_response import SpendControlResponse
from synctera_client.models.spend_control_response_list import SpendControlResponseList
from synctera_client.models.spend_control_update_request import SpendControlUpdateRequest

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class SpendControlsBetaApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_spend_control(self, spend_control : Annotated[SpendControl, Field(..., description="Details of the spend control to create")], **kwargs) -> SpendControlResponse:  # noqa: E501
        """Create Spend Control  # noqa: E501

        Create a spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spend_control(spend_control, async_req=True)
        >>> result = thread.get()

        :param spend_control: Details of the spend control to create (required)
        :type spend_control: SpendControl
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendControlResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_spend_control_with_http_info(spend_control, **kwargs)  # noqa: E501

    @validate_arguments
    def create_spend_control_with_http_info(self, spend_control : Annotated[SpendControl, Field(..., description="Details of the spend control to create")], **kwargs):  # noqa: E501
        """Create Spend Control  # noqa: E501

        Create a spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_spend_control_with_http_info(spend_control, async_req=True)
        >>> result = thread.get()

        :param spend_control: Details of the spend control to create (required)
        :type spend_control: SpendControl
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendControlResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'spend_control'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_spend_control" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['spend_control']:
            _body_params = _params['spend_control']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "SpendControlResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/spend_controls', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_spend_control(self, spend_control_id : StrictStr, **kwargs) -> SpendControlResponse:  # noqa: E501
        """Get Spend Control  # noqa: E501

        Get spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spend_control(spend_control_id, async_req=True)
        >>> result = thread.get()

        :param spend_control_id: (required)
        :type spend_control_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendControlResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_spend_control_with_http_info(spend_control_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_spend_control_with_http_info(self, spend_control_id : StrictStr, **kwargs):  # noqa: E501
        """Get Spend Control  # noqa: E501

        Get spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_spend_control_with_http_info(spend_control_id, async_req=True)
        >>> result = thread.get()

        :param spend_control_id: (required)
        :type spend_control_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendControlResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'spend_control_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_spend_control" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['spend_control_id']:
            _path_params['spend_control_id'] = _params['spend_control_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendControlResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/spend_controls/{spend_control_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_spend_controls(self, account_id : Annotated[Optional[StrictStr], Field(description="return results matching this account ID")] = None, payment_type : Optional[PaymentType] = None, amount_limit : Annotated[Optional[conint(strict=True, gt=0)], Field(description="return results matching this amount limit")] = None, amount_limit_gte : Annotated[Optional[conint(strict=True, gt=0)], Field(description="return results with an amount limit greater than or equal to this")] = None, amount_limit_lte : Annotated[Optional[conint(strict=True, gt=0)], Field(description="return results with an amount limit less than or equal to this")] = None, num_related_accounts : Annotated[Optional[conint(strict=True, ge=0)], Field(description="return results that are associated with this many accounts")] = None, num_related_accounts_gte : Annotated[Optional[conint(strict=True, ge=0)], Field(description="return results that are associated with at least this many accounts")] = None, num_related_accounts_lte : Annotated[Optional[conint(strict=True, ge=0)], Field(description="return results that are associated with at most this many accounts")] = None, is_active : Annotated[Optional[StrictBool], Field(description="return results that match this active status")] = None, name : Annotated[Optional[StrictStr], Field(description="return results that match this name")] = None, direction : Optional[SpendControlDirection] = None, id : Annotated[Optional[List[StrictStr]], Field(description="return results with these comma-separated IDs")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for returned Spend Controls. ")] = None, **kwargs) -> SpendControlResponseList:  # noqa: E501
        """List Spend Controls  # noqa: E501

        List spend controls   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spend_controls(account_id, payment_type, amount_limit, amount_limit_gte, amount_limit_lte, num_related_accounts, num_related_accounts_gte, num_related_accounts_lte, is_active, name, direction, id, sort_by, async_req=True)
        >>> result = thread.get()

        :param account_id: return results matching this account ID
        :type account_id: str
        :param payment_type:
        :type payment_type: PaymentType
        :param amount_limit: return results matching this amount limit
        :type amount_limit: int
        :param amount_limit_gte: return results with an amount limit greater than or equal to this
        :type amount_limit_gte: int
        :param amount_limit_lte: return results with an amount limit less than or equal to this
        :type amount_limit_lte: int
        :param num_related_accounts: return results that are associated with this many accounts
        :type num_related_accounts: int
        :param num_related_accounts_gte: return results that are associated with at least this many accounts
        :type num_related_accounts_gte: int
        :param num_related_accounts_lte: return results that are associated with at most this many accounts
        :type num_related_accounts_lte: int
        :param is_active: return results that match this active status
        :type is_active: bool
        :param name: return results that match this name
        :type name: str
        :param direction:
        :type direction: SpendControlDirection
        :param id: return results with these comma-separated IDs
        :type id: List[str]
        :param sort_by: Specifies the sort order for returned Spend Controls. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendControlResponseList
        """
        kwargs['_return_http_data_only'] = True
        return self.list_spend_controls_with_http_info(account_id, payment_type, amount_limit, amount_limit_gte, amount_limit_lte, num_related_accounts, num_related_accounts_gte, num_related_accounts_lte, is_active, name, direction, id, sort_by, **kwargs)  # noqa: E501

    @validate_arguments
    def list_spend_controls_with_http_info(self, account_id : Annotated[Optional[StrictStr], Field(description="return results matching this account ID")] = None, payment_type : Optional[PaymentType] = None, amount_limit : Annotated[Optional[conint(strict=True, gt=0)], Field(description="return results matching this amount limit")] = None, amount_limit_gte : Annotated[Optional[conint(strict=True, gt=0)], Field(description="return results with an amount limit greater than or equal to this")] = None, amount_limit_lte : Annotated[Optional[conint(strict=True, gt=0)], Field(description="return results with an amount limit less than or equal to this")] = None, num_related_accounts : Annotated[Optional[conint(strict=True, ge=0)], Field(description="return results that are associated with this many accounts")] = None, num_related_accounts_gte : Annotated[Optional[conint(strict=True, ge=0)], Field(description="return results that are associated with at least this many accounts")] = None, num_related_accounts_lte : Annotated[Optional[conint(strict=True, ge=0)], Field(description="return results that are associated with at most this many accounts")] = None, is_active : Annotated[Optional[StrictBool], Field(description="return results that match this active status")] = None, name : Annotated[Optional[StrictStr], Field(description="return results that match this name")] = None, direction : Optional[SpendControlDirection] = None, id : Annotated[Optional[List[StrictStr]], Field(description="return results with these comma-separated IDs")] = None, sort_by : Annotated[Optional[List[StrictStr]], Field(description="Specifies the sort order for returned Spend Controls. ")] = None, **kwargs):  # noqa: E501
        """List Spend Controls  # noqa: E501

        List spend controls   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_spend_controls_with_http_info(account_id, payment_type, amount_limit, amount_limit_gte, amount_limit_lte, num_related_accounts, num_related_accounts_gte, num_related_accounts_lte, is_active, name, direction, id, sort_by, async_req=True)
        >>> result = thread.get()

        :param account_id: return results matching this account ID
        :type account_id: str
        :param payment_type:
        :type payment_type: PaymentType
        :param amount_limit: return results matching this amount limit
        :type amount_limit: int
        :param amount_limit_gte: return results with an amount limit greater than or equal to this
        :type amount_limit_gte: int
        :param amount_limit_lte: return results with an amount limit less than or equal to this
        :type amount_limit_lte: int
        :param num_related_accounts: return results that are associated with this many accounts
        :type num_related_accounts: int
        :param num_related_accounts_gte: return results that are associated with at least this many accounts
        :type num_related_accounts_gte: int
        :param num_related_accounts_lte: return results that are associated with at most this many accounts
        :type num_related_accounts_lte: int
        :param is_active: return results that match this active status
        :type is_active: bool
        :param name: return results that match this name
        :type name: str
        :param direction:
        :type direction: SpendControlDirection
        :param id: return results with these comma-separated IDs
        :type id: List[str]
        :param sort_by: Specifies the sort order for returned Spend Controls. 
        :type sort_by: List[str]
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendControlResponseList, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'account_id',
            'payment_type',
            'amount_limit',
            'amount_limit_gte',
            'amount_limit_lte',
            'num_related_accounts',
            'num_related_accounts_gte',
            'num_related_accounts_lte',
            'is_active',
            'name',
            'direction',
            'id',
            'sort_by'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_spend_controls" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('account_id') is not None:  # noqa: E501
            _query_params.append(('account_id', _params['account_id']))
        if _params.get('payment_type') is not None:  # noqa: E501
            _query_params.append(('payment_type', _params['payment_type']))
        if _params.get('amount_limit') is not None:  # noqa: E501
            _query_params.append(('amount_limit', _params['amount_limit']))
        if _params.get('amount_limit_gte') is not None:  # noqa: E501
            _query_params.append(('amount_limit_gte', _params['amount_limit_gte']))
        if _params.get('amount_limit_lte') is not None:  # noqa: E501
            _query_params.append(('amount_limit_lte', _params['amount_limit_lte']))
        if _params.get('num_related_accounts') is not None:  # noqa: E501
            _query_params.append(('num_related_accounts', _params['num_related_accounts']))
        if _params.get('num_related_accounts_gte') is not None:  # noqa: E501
            _query_params.append(('num_related_accounts_gte', _params['num_related_accounts_gte']))
        if _params.get('num_related_accounts_lte') is not None:  # noqa: E501
            _query_params.append(('num_related_accounts_lte', _params['num_related_accounts_lte']))
        if _params.get('is_active') is not None:  # noqa: E501
            _query_params.append(('is_active', _params['is_active']))
        if _params.get('name') is not None:  # noqa: E501
            _query_params.append(('name', _params['name']))
        if _params.get('direction') is not None:  # noqa: E501
            _query_params.append(('direction', _params['direction']))
        if _params.get('id') is not None:  # noqa: E501
            _query_params.append(('id', _params['id']))
            _collection_formats['id'] = 'csv'
        if _params.get('sort_by') is not None:  # noqa: E501
            _query_params.append(('sort_by', _params['sort_by']))
            _collection_formats['sort_by'] = 'csv'

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendControlResponseList",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/spend_controls', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_spend_control(self, spend_control_id : StrictStr, spend_control_update_request : Annotated[SpendControlUpdateRequest, Field(..., description="Fields to update")], **kwargs) -> SpendControlResponse:  # noqa: E501
        """Update Spend Control  # noqa: E501

        Update spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_spend_control(spend_control_id, spend_control_update_request, async_req=True)
        >>> result = thread.get()

        :param spend_control_id: (required)
        :type spend_control_id: str
        :param spend_control_update_request: Fields to update (required)
        :type spend_control_update_request: SpendControlUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: SpendControlResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_spend_control_with_http_info(spend_control_id, spend_control_update_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_spend_control_with_http_info(self, spend_control_id : StrictStr, spend_control_update_request : Annotated[SpendControlUpdateRequest, Field(..., description="Fields to update")], **kwargs):  # noqa: E501
        """Update Spend Control  # noqa: E501

        Update spend control   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_spend_control_with_http_info(spend_control_id, spend_control_update_request, async_req=True)
        >>> result = thread.get()

        :param spend_control_id: (required)
        :type spend_control_id: str
        :param spend_control_update_request: Fields to update (required)
        :type spend_control_update_request: SpendControlUpdateRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(SpendControlResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'spend_control_id',
            'spend_control_update_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_spend_control" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['spend_control_id']:
            _path_params['spend_control_id'] = _params['spend_control_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['spend_control_update_request']:
            _body_params = _params['spend_control_update_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "SpendControlResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/spend_controls/{spend_control_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
