# coding: utf-8

"""
    Synctera API

    <h2>Let's build something great.</h2><p>Welcome to the official reference documentation for Synctera APIs. Our APIs are the best way to automate your company's banking needs and are designed to be easy to understand and implement.</p><p>We're continuously growing this library and what you see here is just the start, but if you need something specific or have a question, <a class='text-blue-600' href='https://synctera.com/contact' target='_blank' rel='noreferrer'>contact us</a>.</p>   # noqa: E501

    The version of the OpenAPI document: 0.32.0.dev3
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

from pydantic import validate_arguments, ValidationError
from typing_extensions import Annotated

from pydantic import Field, StrictStr, conint

from typing import Optional

from synctera_client.models.apple_digital_wallet_provision_request import AppleDigitalWalletProvisionRequest
from synctera_client.models.apple_digital_wallet_provision_response import AppleDigitalWalletProvisionResponse
from synctera_client.models.digital_wallet_token_edit_request import DigitalWalletTokenEditRequest
from synctera_client.models.digital_wallet_token_response import DigitalWalletTokenResponse
from synctera_client.models.digital_wallet_token_state import DigitalWalletTokenState
from synctera_client.models.google_digital_wallet_provision_request import GoogleDigitalWalletProvisionRequest
from synctera_client.models.google_digital_wallet_provision_response import GoogleDigitalWalletProvisionResponse
from synctera_client.models.token_list_response import TokenListResponse

from synctera_client.api_client import ApiClient
from synctera_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DigitalWalletTokensApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client

    @validate_arguments
    def create_digital_wallet_apple(self, card_id : StrictStr, apple_digital_wallet_provision_request : Annotated[AppleDigitalWalletProvisionRequest, Field(..., description="Request to provision digital wallet card data to pass to Apple Pay digital wallet")], **kwargs) -> AppleDigitalWalletProvisionResponse:  # noqa: E501
        """Create digital wallet token provision request for Apple Pay  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_digital_wallet_apple(card_id, apple_digital_wallet_provision_request, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param apple_digital_wallet_provision_request: Request to provision digital wallet card data to pass to Apple Pay digital wallet (required)
        :type apple_digital_wallet_provision_request: AppleDigitalWalletProvisionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: AppleDigitalWalletProvisionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_digital_wallet_apple_with_http_info(card_id, apple_digital_wallet_provision_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_digital_wallet_apple_with_http_info(self, card_id : StrictStr, apple_digital_wallet_provision_request : Annotated[AppleDigitalWalletProvisionRequest, Field(..., description="Request to provision digital wallet card data to pass to Apple Pay digital wallet")], **kwargs):  # noqa: E501
        """Create digital wallet token provision request for Apple Pay  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_digital_wallet_apple_with_http_info(card_id, apple_digital_wallet_provision_request, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param apple_digital_wallet_provision_request: Request to provision digital wallet card data to pass to Apple Pay digital wallet (required)
        :type apple_digital_wallet_provision_request: AppleDigitalWalletProvisionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(AppleDigitalWalletProvisionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id',
            'apple_digital_wallet_provision_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_digital_wallet_apple" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['apple_digital_wallet_provision_request']:
            _body_params = _params['apple_digital_wallet_provision_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "AppleDigitalWalletProvisionResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}/digital_wallet_tokens/applepay', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def create_digital_wallet_google(self, card_id : StrictStr, google_digital_wallet_provision_request : Annotated[GoogleDigitalWalletProvisionRequest, Field(..., description="Request to provision digital wallet card data to pass to Google Pay digital wallet")], **kwargs) -> GoogleDigitalWalletProvisionResponse:  # noqa: E501
        """Create digital wallet token provision request for Google Pay  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_digital_wallet_google(card_id, google_digital_wallet_provision_request, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param google_digital_wallet_provision_request: Request to provision digital wallet card data to pass to Google Pay digital wallet (required)
        :type google_digital_wallet_provision_request: GoogleDigitalWalletProvisionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: GoogleDigitalWalletProvisionResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.create_digital_wallet_google_with_http_info(card_id, google_digital_wallet_provision_request, **kwargs)  # noqa: E501

    @validate_arguments
    def create_digital_wallet_google_with_http_info(self, card_id : StrictStr, google_digital_wallet_provision_request : Annotated[GoogleDigitalWalletProvisionRequest, Field(..., description="Request to provision digital wallet card data to pass to Google Pay digital wallet")], **kwargs):  # noqa: E501
        """Create digital wallet token provision request for Google Pay  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.create_digital_wallet_google_with_http_info(card_id, google_digital_wallet_provision_request, async_req=True)
        >>> result = thread.get()

        :param card_id: (required)
        :type card_id: str
        :param google_digital_wallet_provision_request: Request to provision digital wallet card data to pass to Google Pay digital wallet (required)
        :type google_digital_wallet_provision_request: GoogleDigitalWalletProvisionRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(GoogleDigitalWalletProvisionResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id',
            'google_digital_wallet_provision_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_digital_wallet_google" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['card_id']:
            _path_params['card_id'] = _params['card_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['google_digital_wallet_provision_request']:
            _body_params = _params['google_digital_wallet_provision_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '201': "GoogleDigitalWalletProvisionResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/{card_id}/digital_wallet_tokens/googlepay', 'POST',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def get_digital_wallet_token(self, digital_wallet_token_id : StrictStr, **kwargs) -> DigitalWalletTokenResponse:  # noqa: E501
        """Get Digital Wallet Token  # noqa: E501

        Get the details about the digital wallet token of a card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_digital_wallet_token(digital_wallet_token_id, async_req=True)
        >>> result = thread.get()

        :param digital_wallet_token_id: (required)
        :type digital_wallet_token_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DigitalWalletTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.get_digital_wallet_token_with_http_info(digital_wallet_token_id, **kwargs)  # noqa: E501

    @validate_arguments
    def get_digital_wallet_token_with_http_info(self, digital_wallet_token_id : StrictStr, **kwargs):  # noqa: E501
        """Get Digital Wallet Token  # noqa: E501

        Get the details about the digital wallet token of a card   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.get_digital_wallet_token_with_http_info(digital_wallet_token_id, async_req=True)
        >>> result = thread.get()

        :param digital_wallet_token_id: (required)
        :type digital_wallet_token_id: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DigitalWalletTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'digital_wallet_token_id'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_digital_wallet_token" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['digital_wallet_token_id']:
            _path_params['digital_wallet_token_id'] = _params['digital_wallet_token_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "DigitalWalletTokenResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/digital_wallet_tokens/{digital_wallet_token_id}', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def list_digital_wallet_tokens(self, card_id : Optional[StrictStr] = None, token_state : Annotated[Optional[DigitalWalletTokenState], Field(description="The status of the Digital Wallet Token")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs) -> TokenListResponse:  # noqa: E501
        """List Digital Wallet Tokens  # noqa: E501

        List Digital Wallet Tokens   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_digital_wallet_tokens(card_id, token_state, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param card_id:
        :type card_id: str
        :param token_state: The status of the Digital Wallet Token
        :type token_state: DigitalWalletTokenState
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: TokenListResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.list_digital_wallet_tokens_with_http_info(card_id, token_state, limit, page_token, **kwargs)  # noqa: E501

    @validate_arguments
    def list_digital_wallet_tokens_with_http_info(self, card_id : Optional[StrictStr] = None, token_state : Annotated[Optional[DigitalWalletTokenState], Field(description="The status of the Digital Wallet Token")] = None, limit : Optional[conint(strict=True, ge=1)] = None, page_token : Optional[StrictStr] = None, **kwargs):  # noqa: E501
        """List Digital Wallet Tokens  # noqa: E501

        List Digital Wallet Tokens   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.list_digital_wallet_tokens_with_http_info(card_id, token_state, limit, page_token, async_req=True)
        >>> result = thread.get()

        :param card_id:
        :type card_id: str
        :param token_state: The status of the Digital Wallet Token
        :type token_state: DigitalWalletTokenState
        :param limit:
        :type limit: int
        :param page_token:
        :type page_token: str
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(TokenListResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'card_id',
            'token_state',
            'limit',
            'page_token'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_digital_wallet_tokens" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}

        # process the query parameters
        _query_params = []
        if _params.get('card_id') is not None:  # noqa: E501
            _query_params.append(('card_id', _params['card_id']))
        if _params.get('token_state') is not None:  # noqa: E501
            _query_params.append(('token_state', _params['token_state']))
        if _params.get('limit') is not None:  # noqa: E501
            _query_params.append(('limit', _params['limit']))
        if _params.get('page_token') is not None:  # noqa: E501
            _query_params.append(('page_token', _params['page_token']))

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "TokenListResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/digital_wallet_tokens', 'GET',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))

    @validate_arguments
    def update_digital_wallet_token_status(self, digital_wallet_token_id : StrictStr, digital_wallet_token_edit_request : Annotated[DigitalWalletTokenEditRequest, Field(..., description="Update Digital wallet token status")], **kwargs) -> DigitalWalletTokenResponse:  # noqa: E501
        """Update Digital Wallet Token's life cycle status  # noqa: E501

        The status of a digital wallet token can be updated as, ACTIVE to SUSPENDED, SUSPENDED to ACTIVE, ACTIVE to TERMINATED or SUSPENDED to TERMINATED.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_digital_wallet_token_status(digital_wallet_token_id, digital_wallet_token_edit_request, async_req=True)
        >>> result = thread.get()

        :param digital_wallet_token_id: (required)
        :type digital_wallet_token_id: str
        :param digital_wallet_token_edit_request: Update Digital wallet token status (required)
        :type digital_wallet_token_edit_request: DigitalWalletTokenEditRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: DigitalWalletTokenResponse
        """
        kwargs['_return_http_data_only'] = True
        return self.update_digital_wallet_token_status_with_http_info(digital_wallet_token_id, digital_wallet_token_edit_request, **kwargs)  # noqa: E501

    @validate_arguments
    def update_digital_wallet_token_status_with_http_info(self, digital_wallet_token_id : StrictStr, digital_wallet_token_edit_request : Annotated[DigitalWalletTokenEditRequest, Field(..., description="Update Digital wallet token status")], **kwargs):  # noqa: E501
        """Update Digital Wallet Token's life cycle status  # noqa: E501

        The status of a digital wallet token can be updated as, ACTIVE to SUSPENDED, SUSPENDED to ACTIVE, ACTIVE to TERMINATED or SUSPENDED to TERMINATED.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True

        >>> thread = api.update_digital_wallet_token_status_with_http_info(digital_wallet_token_id, digital_wallet_token_edit_request, async_req=True)
        >>> result = thread.get()

        :param digital_wallet_token_id: (required)
        :type digital_wallet_token_id: str
        :param digital_wallet_token_edit_request: Update Digital wallet token status (required)
        :type digital_wallet_token_edit_request: DigitalWalletTokenEditRequest
        :param async_req: Whether to execute the request asynchronously.
        :type async_req: bool, optional
        :param _return_http_data_only: response data without head status code
                                       and headers
        :type _return_http_data_only: bool, optional
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :type _preload_content: bool, optional
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the authentication
                              in the spec for a single request.
        :type _request_auth: dict, optional
        :type _content_type: string, optional: force content-type for the request
        :return: Returns the result object.
                 If the method is called asynchronously,
                 returns the request thread.
        :rtype: tuple(DigitalWalletTokenResponse, status_code(int), headers(HTTPHeaderDict))
        """

        _params = locals()

        _all_params = [
            'digital_wallet_token_id',
            'digital_wallet_token_edit_request'
        ]
        _all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout',
                '_request_auth',
                '_content_type',
                '_headers'
            ]
        )

        # validate the arguments
        for _key, _val in _params['kwargs'].items():
            if _key not in _all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_digital_wallet_token_status" % _key
                )
            _params[_key] = _val
        del _params['kwargs']

        _collection_formats = {}

        # process the path parameters
        _path_params = {}
        if _params['digital_wallet_token_id']:
            _path_params['digital_wallet_token_id'] = _params['digital_wallet_token_id']

        # process the query parameters
        _query_params = []

        # process the header parameters
        _header_params = dict(_params.get('_headers', {}))

        # process the form parameters
        _form_params = []
        _files = {}

        # process the body parameter
        _body_params = None
        if _params['digital_wallet_token_edit_request']:
            _body_params = _params['digital_wallet_token_edit_request']

        # set the HTTP header `Accept`
        _header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/problem+json'])  # noqa: E501

        # set the HTTP header `Content-Type`
        _content_types_list = _params.get('_content_type',
            self.api_client.select_header_content_type(
                ['application/json']))
        if _content_types_list:
                _header_params['Content-Type'] = _content_types_list

        # authentication setting
        _auth_settings = ['bearerAuth']  # noqa: E501

        _response_types_map = {
            '200': "DigitalWalletTokenResponse",
            '400': "Error",
            '401': "Error",
            '403': "Error",
            '422': "Error",
            '500': "Error",
        }

        return self.api_client.call_api(
            '/cards/digital_wallet_tokens/{digital_wallet_token_id}', 'PATCH',
            _path_params,
            _query_params,
            _header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            response_types_map=_response_types_map,
            auth_settings=_auth_settings,
            async_req=_params.get('async_req'),
            _return_http_data_only=_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=_params.get('_preload_content', True),
            _request_timeout=_params.get('_request_timeout'),
            collection_formats=_collection_formats,
            _request_auth=_params.get('_request_auth'))
